package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RefreshSchemasResponse(
    refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse = {
    import RefreshSchemasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse
      .builder()
      .optionallyWith(refreshSchemasStatus.map(value => value.buildAwsValue()))(
        _.refreshSchemasStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly =
    zio.aws.databasemigration.model.RefreshSchemasResponse.wrap(buildAwsValue())
}
object RefreshSchemasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RefreshSchemasResponse =
      zio.aws.databasemigration.model.RefreshSchemasResponse(
        refreshSchemasStatus.map(value => value.asEditable)
      )
    def refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ]
    def getRefreshSchemasStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ] = AwsError.unwrapOptionField("refreshSchemasStatus", refreshSchemasStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse
  ) extends zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly {
    override val refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshSchemasStatus())
      .map(value =>
        zio.aws.databasemigration.model.RefreshSchemasStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse
  ): zio.aws.databasemigration.model.RefreshSchemasResponse.ReadOnly =
    new Wrapper(impl)
}
