package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters.*
final case class Recommendation(
    databaseId: Optional[String] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    createdDate: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    preferred: Optional[BooleanOptional] = Optional.Absent,
    settings: Optional[zio.aws.databasemigration.model.RecommendationSettings] =
      Optional.Absent,
    data: Optional[zio.aws.databasemigration.model.RecommendationData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.Recommendation
      .builder()
      .optionallyWith(databaseId.map(value => value: java.lang.String))(
        _.databaseId
      )
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(createdDate.map(value => value: java.lang.String))(
        _.createdDate
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(preferred.map(value => value: java.lang.Boolean))(
        _.preferred
      )
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(data.map(value => value.buildAwsValue()))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.Recommendation.ReadOnly =
    zio.aws.databasemigration.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.Recommendation =
      zio.aws.databasemigration.model.Recommendation(
        databaseId.map(value => value),
        engineName.map(value => value),
        createdDate.map(value => value),
        status.map(value => value),
        preferred.map(value => value),
        settings.map(value => value.asEditable),
        data.map(value => value.asEditable)
      )
    def databaseId: Optional[String]
    def engineName: Optional[String]
    def createdDate: Optional[String]
    def status: Optional[String]
    def preferred: Optional[BooleanOptional]
    def settings: Optional[
      zio.aws.databasemigration.model.RecommendationSettings.ReadOnly
    ]
    def data
        : Optional[zio.aws.databasemigration.model.RecommendationData.ReadOnly]
    def getDatabaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getCreatedDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPreferred: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("preferred", preferred)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RecommendationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getData: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RecommendationData.ReadOnly
    ] = AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.Recommendation
  ) extends zio.aws.databasemigration.model.Recommendation.ReadOnly {
    override val databaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => value: String)
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val createdDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val preferred: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.preferred())
      .map(value => value: BooleanOptional)
    override val settings: Optional[
      zio.aws.databasemigration.model.RecommendationSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.settings())
      .map(value =>
        zio.aws.databasemigration.model.RecommendationSettings.wrap(value)
      )
    override val data: Optional[
      zio.aws.databasemigration.model.RecommendationData.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value =>
        zio.aws.databasemigration.model.RecommendationData.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.Recommendation
  ): zio.aws.databasemigration.model.Recommendation.ReadOnly = new Wrapper(impl)
}
