package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  IntegerOptional,
  DoubleOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RdsRequirements(
    engineEdition: Optional[String] = Optional.Absent,
    instanceVcpu: Optional[DoubleOptional] = Optional.Absent,
    instanceMemory: Optional[DoubleOptional] = Optional.Absent,
    storageSize: Optional[IntegerOptional] = Optional.Absent,
    storageIops: Optional[IntegerOptional] = Optional.Absent,
    deploymentOption: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RdsRequirements = {
    import RdsRequirements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RdsRequirements
      .builder()
      .optionallyWith(engineEdition.map(value => value: java.lang.String))(
        _.engineEdition
      )
      .optionallyWith(instanceVcpu.map(value => value: java.lang.Double))(
        _.instanceVcpu
      )
      .optionallyWith(instanceMemory.map(value => value: java.lang.Double))(
        _.instanceMemory
      )
      .optionallyWith(storageSize.map(value => value: Integer))(_.storageSize)
      .optionallyWith(storageIops.map(value => value: Integer))(_.storageIops)
      .optionallyWith(deploymentOption.map(value => value: java.lang.String))(
        _.deploymentOption
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RdsRequirements.ReadOnly =
    zio.aws.databasemigration.model.RdsRequirements.wrap(buildAwsValue())
}
object RdsRequirements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RdsRequirements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RdsRequirements =
      zio.aws.databasemigration.model.RdsRequirements(
        engineEdition.map(value => value),
        instanceVcpu.map(value => value),
        instanceMemory.map(value => value),
        storageSize.map(value => value),
        storageIops.map(value => value),
        deploymentOption.map(value => value),
        engineVersion.map(value => value)
      )
    def engineEdition: Optional[String]
    def instanceVcpu: Optional[DoubleOptional]
    def instanceMemory: Optional[DoubleOptional]
    def storageSize: Optional[IntegerOptional]
    def storageIops: Optional[IntegerOptional]
    def deploymentOption: Optional[String]
    def engineVersion: Optional[String]
    def getEngineEdition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineEdition", engineEdition)
    def getInstanceVcpu: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("instanceVcpu", instanceVcpu)
    def getInstanceMemory: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("instanceMemory", instanceMemory)
    def getStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageSize", storageSize)
    def getStorageIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageIops", storageIops)
    def getDeploymentOption: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentOption", deploymentOption)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsRequirements
  ) extends zio.aws.databasemigration.model.RdsRequirements.ReadOnly {
    override val engineEdition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineEdition())
      .map(value => value: String)
    override val instanceVcpu: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceVcpu())
      .map(value => value: DoubleOptional)
    override val instanceMemory: Optional[DoubleOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMemory())
        .map(value => value: DoubleOptional)
    override val storageSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.storageSize())
      .map(value => value: IntegerOptional)
    override val storageIops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.storageIops())
      .map(value => value: IntegerOptional)
    override val deploymentOption: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentOption())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RdsRequirements
  ): zio.aws.databasemigration.model.RdsRequirements.ReadOnly = new Wrapper(
    impl
  )
}
