package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PostgreSQLSettings(
    afterConnectScript: Optional[String] = Optional.Absent,
    captureDdls: Optional[BooleanOptional] = Optional.Absent,
    maxFileSize: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    ddlArtifactsSchema: Optional[String] = Optional.Absent,
    executeTimeout: Optional[IntegerOptional] = Optional.Absent,
    failTasksOnLobTruncation: Optional[BooleanOptional] = Optional.Absent,
    heartbeatEnable: Optional[BooleanOptional] = Optional.Absent,
    heartbeatSchema: Optional[String] = Optional.Absent,
    heartbeatFrequency: Optional[IntegerOptional] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    slotName: Optional[String] = Optional.Absent,
    pluginName: Optional[zio.aws.databasemigration.model.PluginNameValue] =
      Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    trimSpaceInChar: Optional[BooleanOptional] = Optional.Absent,
    mapBooleanAsBoolean: Optional[BooleanOptional] = Optional.Absent,
    mapJsonbAsClob: Optional[BooleanOptional] = Optional.Absent,
    mapLongVarcharAs: Optional[
      zio.aws.databasemigration.model.LongVarcharMappingType
    ] = Optional.Absent,
    databaseMode: Optional[zio.aws.databasemigration.model.DatabaseMode] =
      Optional.Absent,
    babelfishDatabaseName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings = {
    import PostgreSQLSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
      .builder()
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(captureDdls.map(value => value: java.lang.Boolean))(
        _.captureDdls
      )
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(ddlArtifactsSchema.map(value => value: java.lang.String))(
        _.ddlArtifactsSchema
      )
      .optionallyWith(executeTimeout.map(value => value: Integer))(
        _.executeTimeout
      )
      .optionallyWith(
        failTasksOnLobTruncation.map(value => value: java.lang.Boolean)
      )(_.failTasksOnLobTruncation)
      .optionallyWith(heartbeatEnable.map(value => value: java.lang.Boolean))(
        _.heartbeatEnable
      )
      .optionallyWith(heartbeatSchema.map(value => value: java.lang.String))(
        _.heartbeatSchema
      )
      .optionallyWith(heartbeatFrequency.map(value => value: Integer))(
        _.heartbeatFrequency
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(slotName.map(value => value: java.lang.String))(
        _.slotName
      )
      .optionallyWith(pluginName.map(value => value.unwrap))(_.pluginName)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(trimSpaceInChar.map(value => value: java.lang.Boolean))(
        _.trimSpaceInChar
      )
      .optionallyWith(
        mapBooleanAsBoolean.map(value => value: java.lang.Boolean)
      )(_.mapBooleanAsBoolean)
      .optionallyWith(mapJsonbAsClob.map(value => value: java.lang.Boolean))(
        _.mapJsonbAsClob
      )
      .optionallyWith(mapLongVarcharAs.map(value => value.unwrap))(
        _.mapLongVarcharAs
      )
      .optionallyWith(databaseMode.map(value => value.unwrap))(_.databaseMode)
      .optionallyWith(
        babelfishDatabaseName.map(value => value: java.lang.String)
      )(_.babelfishDatabaseName)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly =
    zio.aws.databasemigration.model.PostgreSQLSettings.wrap(buildAwsValue())
}
object PostgreSQLSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.PostgreSQLSettings =
      zio.aws.databasemigration.model.PostgreSQLSettings(
        afterConnectScript.map(value => value),
        captureDdls.map(value => value),
        maxFileSize.map(value => value),
        databaseName.map(value => value),
        ddlArtifactsSchema.map(value => value),
        executeTimeout.map(value => value),
        failTasksOnLobTruncation.map(value => value),
        heartbeatEnable.map(value => value),
        heartbeatSchema.map(value => value),
        heartbeatFrequency.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        slotName.map(value => value),
        pluginName.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value),
        trimSpaceInChar.map(value => value),
        mapBooleanAsBoolean.map(value => value),
        mapJsonbAsClob.map(value => value),
        mapLongVarcharAs.map(value => value),
        databaseMode.map(value => value),
        babelfishDatabaseName.map(value => value)
      )
    def afterConnectScript: Optional[String]
    def captureDdls: Optional[BooleanOptional]
    def maxFileSize: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def ddlArtifactsSchema: Optional[String]
    def executeTimeout: Optional[IntegerOptional]
    def failTasksOnLobTruncation: Optional[BooleanOptional]
    def heartbeatEnable: Optional[BooleanOptional]
    def heartbeatSchema: Optional[String]
    def heartbeatFrequency: Optional[IntegerOptional]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def serverName: Optional[String]
    def username: Optional[String]
    def slotName: Optional[String]
    def pluginName: Optional[zio.aws.databasemigration.model.PluginNameValue]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def trimSpaceInChar: Optional[BooleanOptional]
    def mapBooleanAsBoolean: Optional[BooleanOptional]
    def mapJsonbAsClob: Optional[BooleanOptional]
    def mapLongVarcharAs
        : Optional[zio.aws.databasemigration.model.LongVarcharMappingType]
    def databaseMode: Optional[zio.aws.databasemigration.model.DatabaseMode]
    def babelfishDatabaseName: Optional[String]
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getCaptureDdls: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("captureDdls", captureDdls)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDdlArtifactsSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ddlArtifactsSchema", ddlArtifactsSchema)
    def getExecuteTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("executeTimeout", executeTimeout)
    def getFailTasksOnLobTruncation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "failTasksOnLobTruncation",
        failTasksOnLobTruncation
      )
    def getHeartbeatEnable: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("heartbeatEnable", heartbeatEnable)
    def getHeartbeatSchema: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("heartbeatSchema", heartbeatSchema)
    def getHeartbeatFrequency: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("heartbeatFrequency", heartbeatFrequency)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSlotName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("slotName", slotName)
    def getPluginName
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.PluginNameValue] =
      AwsError.unwrapOptionField("pluginName", pluginName)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getTrimSpaceInChar: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("trimSpaceInChar", trimSpaceInChar)
    def getMapBooleanAsBoolean: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("mapBooleanAsBoolean", mapBooleanAsBoolean)
    def getMapJsonbAsClob: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("mapJsonbAsClob", mapJsonbAsClob)
    def getMapLongVarcharAs: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.LongVarcharMappingType
    ] = AwsError.unwrapOptionField("mapLongVarcharAs", mapLongVarcharAs)
    def getDatabaseMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DatabaseMode] =
      AwsError.unwrapOptionField("databaseMode", databaseMode)
    def getBabelfishDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("babelfishDatabaseName", babelfishDatabaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ) extends zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly {
    override val afterConnectScript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.afterConnectScript())
      .map(value => value: String)
    override val captureDdls: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.captureDdls())
      .map(value => value: BooleanOptional)
    override val maxFileSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileSize())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val ddlArtifactsSchema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ddlArtifactsSchema())
      .map(value => value: String)
    override val executeTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executeTimeout())
        .map(value => value: IntegerOptional)
    override val failTasksOnLobTruncation: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failTasksOnLobTruncation())
        .map(value => value: BooleanOptional)
    override val heartbeatEnable: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatEnable())
        .map(value => value: BooleanOptional)
    override val heartbeatSchema: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.heartbeatSchema())
      .map(value => value: String)
    override val heartbeatFrequency: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatFrequency())
        .map(value => value: IntegerOptional)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val slotName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.slotName())
      .map(value => value: String)
    override val pluginName
        : Optional[zio.aws.databasemigration.model.PluginNameValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pluginName())
        .map(value =>
          zio.aws.databasemigration.model.PluginNameValue.wrap(value)
        )
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val trimSpaceInChar: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trimSpaceInChar())
        .map(value => value: BooleanOptional)
    override val mapBooleanAsBoolean: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapBooleanAsBoolean())
        .map(value => value: BooleanOptional)
    override val mapJsonbAsClob: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapJsonbAsClob())
        .map(value => value: BooleanOptional)
    override val mapLongVarcharAs
        : Optional[zio.aws.databasemigration.model.LongVarcharMappingType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapLongVarcharAs())
        .map(value =>
          zio.aws.databasemigration.model.LongVarcharMappingType.wrap(value)
        )
    override val databaseMode
        : Optional[zio.aws.databasemigration.model.DatabaseMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseMode())
        .map(value => zio.aws.databasemigration.model.DatabaseMode.wrap(value))
    override val babelfishDatabaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.babelfishDatabaseName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings
  ): zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly = new Wrapper(
    impl
  )
}
