package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  Integer,
  IntegerOptional,
  BooleanOptional
}
import scala.jdk.CollectionConverters.*
final case class OracleSettings(
    addSupplementalLogging: Optional[BooleanOptional] = Optional.Absent,
    archivedLogDestId: Optional[IntegerOptional] = Optional.Absent,
    additionalArchivedLogDestId: Optional[IntegerOptional] = Optional.Absent,
    extraArchivedLogDestIds: Optional[Iterable[Integer]] = Optional.Absent,
    allowSelectNestedTables: Optional[BooleanOptional] = Optional.Absent,
    parallelAsmReadThreads: Optional[IntegerOptional] = Optional.Absent,
    readAheadBlocks: Optional[IntegerOptional] = Optional.Absent,
    accessAlternateDirectly: Optional[BooleanOptional] = Optional.Absent,
    useAlternateFolderForOnline: Optional[BooleanOptional] = Optional.Absent,
    oraclePathPrefix: Optional[String] = Optional.Absent,
    usePathPrefix: Optional[String] = Optional.Absent,
    replacePathPrefix: Optional[BooleanOptional] = Optional.Absent,
    enableHomogenousTablespace: Optional[BooleanOptional] = Optional.Absent,
    directPathNoLog: Optional[BooleanOptional] = Optional.Absent,
    archivedLogsOnly: Optional[BooleanOptional] = Optional.Absent,
    asmPassword: Optional[SecretString] = Optional.Absent,
    asmServer: Optional[String] = Optional.Absent,
    asmUser: Optional[String] = Optional.Absent,
    charLengthSemantics: Optional[
      zio.aws.databasemigration.model.CharLengthSemantics
    ] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    directPathParallelLoad: Optional[BooleanOptional] = Optional.Absent,
    failTasksOnLobTruncation: Optional[BooleanOptional] = Optional.Absent,
    numberDatatypeScale: Optional[IntegerOptional] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    readTableSpaceName: Optional[BooleanOptional] = Optional.Absent,
    retryInterval: Optional[IntegerOptional] = Optional.Absent,
    securityDbEncryption: Optional[SecretString] = Optional.Absent,
    securityDbEncryptionName: Optional[String] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    spatialDataOptionToGeoJsonFunctionName: Optional[String] = Optional.Absent,
    standbyDelayTime: Optional[IntegerOptional] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    useBFile: Optional[BooleanOptional] = Optional.Absent,
    useDirectPathFullLoad: Optional[BooleanOptional] = Optional.Absent,
    useLogminerReader: Optional[BooleanOptional] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent,
    secretsManagerOracleAsmAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerOracleAsmSecretId: Optional[String] = Optional.Absent,
    trimSpaceInChar: Optional[BooleanOptional] = Optional.Absent,
    convertTimestampWithZoneToUTC: Optional[BooleanOptional] = Optional.Absent,
    openTransactionWindow: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.OracleSettings = {
    import OracleSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.OracleSettings
      .builder()
      .optionallyWith(
        addSupplementalLogging.map(value => value: java.lang.Boolean)
      )(_.addSupplementalLogging)
      .optionallyWith(archivedLogDestId.map(value => value: java.lang.Integer))(
        _.archivedLogDestId
      )
      .optionallyWith(
        additionalArchivedLogDestId.map(value => value: java.lang.Integer)
      )(_.additionalArchivedLogDestId)
      .optionallyWith(
        extraArchivedLogDestIds.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.extraArchivedLogDestIds)
      .optionallyWith(
        allowSelectNestedTables.map(value => value: java.lang.Boolean)
      )(_.allowSelectNestedTables)
      .optionallyWith(
        parallelAsmReadThreads.map(value => value: java.lang.Integer)
      )(_.parallelAsmReadThreads)
      .optionallyWith(readAheadBlocks.map(value => value: java.lang.Integer))(
        _.readAheadBlocks
      )
      .optionallyWith(
        accessAlternateDirectly.map(value => value: java.lang.Boolean)
      )(_.accessAlternateDirectly)
      .optionallyWith(
        useAlternateFolderForOnline.map(value => value: java.lang.Boolean)
      )(_.useAlternateFolderForOnline)
      .optionallyWith(oraclePathPrefix.map(value => value: java.lang.String))(
        _.oraclePathPrefix
      )
      .optionallyWith(usePathPrefix.map(value => value: java.lang.String))(
        _.usePathPrefix
      )
      .optionallyWith(replacePathPrefix.map(value => value: java.lang.Boolean))(
        _.replacePathPrefix
      )
      .optionallyWith(
        enableHomogenousTablespace.map(value => value: java.lang.Boolean)
      )(_.enableHomogenousTablespace)
      .optionallyWith(directPathNoLog.map(value => value: java.lang.Boolean))(
        _.directPathNoLog
      )
      .optionallyWith(archivedLogsOnly.map(value => value: java.lang.Boolean))(
        _.archivedLogsOnly
      )
      .optionallyWith(
        asmPassword.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.asmPassword)
      .optionallyWith(asmServer.map(value => value: java.lang.String))(
        _.asmServer
      )
      .optionallyWith(asmUser.map(value => value: java.lang.String))(_.asmUser)
      .optionallyWith(charLengthSemantics.map(value => value.unwrap))(
        _.charLengthSemantics
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        directPathParallelLoad.map(value => value: java.lang.Boolean)
      )(_.directPathParallelLoad)
      .optionallyWith(
        failTasksOnLobTruncation.map(value => value: java.lang.Boolean)
      )(_.failTasksOnLobTruncation)
      .optionallyWith(
        numberDatatypeScale.map(value => value: java.lang.Integer)
      )(_.numberDatatypeScale)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        readTableSpaceName.map(value => value: java.lang.Boolean)
      )(_.readTableSpaceName)
      .optionallyWith(retryInterval.map(value => value: java.lang.Integer))(
        _.retryInterval
      )
      .optionallyWith(
        securityDbEncryption.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.securityDbEncryption)
      .optionallyWith(
        securityDbEncryptionName.map(value => value: java.lang.String)
      )(_.securityDbEncryptionName)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        spatialDataOptionToGeoJsonFunctionName.map(value =>
          value: java.lang.String
        )
      )(_.spatialDataOptionToGeoJsonFunctionName)
      .optionallyWith(standbyDelayTime.map(value => value: java.lang.Integer))(
        _.standbyDelayTime
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(useBFile.map(value => value: java.lang.Boolean))(
        _.useBFile
      )
      .optionallyWith(
        useDirectPathFullLoad.map(value => value: java.lang.Boolean)
      )(_.useDirectPathFullLoad)
      .optionallyWith(useLogminerReader.map(value => value: java.lang.Boolean))(
        _.useLogminerReader
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .optionallyWith(
        secretsManagerOracleAsmAccessRoleArn.map(value =>
          value: java.lang.String
        )
      )(_.secretsManagerOracleAsmAccessRoleArn)
      .optionallyWith(
        secretsManagerOracleAsmSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerOracleAsmSecretId)
      .optionallyWith(trimSpaceInChar.map(value => value: java.lang.Boolean))(
        _.trimSpaceInChar
      )
      .optionallyWith(
        convertTimestampWithZoneToUTC.map(value => value: java.lang.Boolean)
      )(_.convertTimestampWithZoneToUTC)
      .optionallyWith(
        openTransactionWindow.map(value => value: java.lang.Integer)
      )(_.openTransactionWindow)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.OracleSettings.ReadOnly =
    zio.aws.databasemigration.model.OracleSettings.wrap(buildAwsValue())
}
object OracleSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.OracleSettings =
      zio.aws.databasemigration.model.OracleSettings(
        addSupplementalLogging.map(value => value),
        archivedLogDestId.map(value => value),
        additionalArchivedLogDestId.map(value => value),
        extraArchivedLogDestIds.map(value => value),
        allowSelectNestedTables.map(value => value),
        parallelAsmReadThreads.map(value => value),
        readAheadBlocks.map(value => value),
        accessAlternateDirectly.map(value => value),
        useAlternateFolderForOnline.map(value => value),
        oraclePathPrefix.map(value => value),
        usePathPrefix.map(value => value),
        replacePathPrefix.map(value => value),
        enableHomogenousTablespace.map(value => value),
        directPathNoLog.map(value => value),
        archivedLogsOnly.map(value => value),
        asmPassword.map(value => value),
        asmServer.map(value => value),
        asmUser.map(value => value),
        charLengthSemantics.map(value => value),
        databaseName.map(value => value),
        directPathParallelLoad.map(value => value),
        failTasksOnLobTruncation.map(value => value),
        numberDatatypeScale.map(value => value),
        password.map(value => value),
        port.map(value => value),
        readTableSpaceName.map(value => value),
        retryInterval.map(value => value),
        securityDbEncryption.map(value => value),
        securityDbEncryptionName.map(value => value),
        serverName.map(value => value),
        spatialDataOptionToGeoJsonFunctionName.map(value => value),
        standbyDelayTime.map(value => value),
        username.map(value => value),
        useBFile.map(value => value),
        useDirectPathFullLoad.map(value => value),
        useLogminerReader.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value),
        secretsManagerOracleAsmAccessRoleArn.map(value => value),
        secretsManagerOracleAsmSecretId.map(value => value),
        trimSpaceInChar.map(value => value),
        convertTimestampWithZoneToUTC.map(value => value),
        openTransactionWindow.map(value => value)
      )
    def addSupplementalLogging: Optional[BooleanOptional]
    def archivedLogDestId: Optional[IntegerOptional]
    def additionalArchivedLogDestId: Optional[IntegerOptional]
    def extraArchivedLogDestIds: Optional[List[Integer]]
    def allowSelectNestedTables: Optional[BooleanOptional]
    def parallelAsmReadThreads: Optional[IntegerOptional]
    def readAheadBlocks: Optional[IntegerOptional]
    def accessAlternateDirectly: Optional[BooleanOptional]
    def useAlternateFolderForOnline: Optional[BooleanOptional]
    def oraclePathPrefix: Optional[String]
    def usePathPrefix: Optional[String]
    def replacePathPrefix: Optional[BooleanOptional]
    def enableHomogenousTablespace: Optional[BooleanOptional]
    def directPathNoLog: Optional[BooleanOptional]
    def archivedLogsOnly: Optional[BooleanOptional]
    def asmPassword: Optional[SecretString]
    def asmServer: Optional[String]
    def asmUser: Optional[String]
    def charLengthSemantics
        : Optional[zio.aws.databasemigration.model.CharLengthSemantics]
    def databaseName: Optional[String]
    def directPathParallelLoad: Optional[BooleanOptional]
    def failTasksOnLobTruncation: Optional[BooleanOptional]
    def numberDatatypeScale: Optional[IntegerOptional]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def readTableSpaceName: Optional[BooleanOptional]
    def retryInterval: Optional[IntegerOptional]
    def securityDbEncryption: Optional[SecretString]
    def securityDbEncryptionName: Optional[String]
    def serverName: Optional[String]
    def spatialDataOptionToGeoJsonFunctionName: Optional[String]
    def standbyDelayTime: Optional[IntegerOptional]
    def username: Optional[String]
    def useBFile: Optional[BooleanOptional]
    def useDirectPathFullLoad: Optional[BooleanOptional]
    def useLogminerReader: Optional[BooleanOptional]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def secretsManagerOracleAsmAccessRoleArn: Optional[String]
    def secretsManagerOracleAsmSecretId: Optional[String]
    def trimSpaceInChar: Optional[BooleanOptional]
    def convertTimestampWithZoneToUTC: Optional[BooleanOptional]
    def openTransactionWindow: Optional[IntegerOptional]
    def getAddSupplementalLogging: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "addSupplementalLogging",
        addSupplementalLogging
      )
    def getArchivedLogDestId: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("archivedLogDestId", archivedLogDestId)
    def getAdditionalArchivedLogDestId: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "additionalArchivedLogDestId",
        additionalArchivedLogDestId
      )
    def getExtraArchivedLogDestIds: ZIO[Any, AwsError, List[Integer]] = AwsError
      .unwrapOptionField("extraArchivedLogDestIds", extraArchivedLogDestIds)
    def getAllowSelectNestedTables: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "allowSelectNestedTables",
        allowSelectNestedTables
      )
    def getParallelAsmReadThreads: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "parallelAsmReadThreads",
        parallelAsmReadThreads
      )
    def getReadAheadBlocks: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("readAheadBlocks", readAheadBlocks)
    def getAccessAlternateDirectly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "accessAlternateDirectly",
        accessAlternateDirectly
      )
    def getUseAlternateFolderForOnline: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useAlternateFolderForOnline",
        useAlternateFolderForOnline
      )
    def getOraclePathPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("oraclePathPrefix", oraclePathPrefix)
    def getUsePathPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usePathPrefix", usePathPrefix)
    def getReplacePathPrefix: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("replacePathPrefix", replacePathPrefix)
    def getEnableHomogenousTablespace: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableHomogenousTablespace",
        enableHomogenousTablespace
      )
    def getDirectPathNoLog: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("directPathNoLog", directPathNoLog)
    def getArchivedLogsOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("archivedLogsOnly", archivedLogsOnly)
    def getAsmPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("asmPassword", asmPassword)
    def getAsmServer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asmServer", asmServer)
    def getAsmUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("asmUser", asmUser)
    def getCharLengthSemantics: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.CharLengthSemantics
    ] = AwsError.unwrapOptionField("charLengthSemantics", charLengthSemantics)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDirectPathParallelLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "directPathParallelLoad",
        directPathParallelLoad
      )
    def getFailTasksOnLobTruncation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "failTasksOnLobTruncation",
        failTasksOnLobTruncation
      )
    def getNumberDatatypeScale: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberDatatypeScale", numberDatatypeScale)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getReadTableSpaceName: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("readTableSpaceName", readTableSpaceName)
    def getRetryInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("retryInterval", retryInterval)
    def getSecurityDbEncryption: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("securityDbEncryption", securityDbEncryption)
    def getSecurityDbEncryptionName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("securityDbEncryptionName", securityDbEncryptionName)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getSpatialDataOptionToGeoJsonFunctionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "spatialDataOptionToGeoJsonFunctionName",
        spatialDataOptionToGeoJsonFunctionName
      )
    def getStandbyDelayTime: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("standbyDelayTime", standbyDelayTime)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getUseBFile: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useBFile", useBFile)
    def getUseDirectPathFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useDirectPathFullLoad", useDirectPathFullLoad)
    def getUseLogminerReader: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useLogminerReader", useLogminerReader)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
    def getSecretsManagerOracleAsmAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmAccessRoleArn",
        secretsManagerOracleAsmAccessRoleArn
      )
    def getSecretsManagerOracleAsmSecretId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerOracleAsmSecretId",
        secretsManagerOracleAsmSecretId
      )
    def getTrimSpaceInChar: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("trimSpaceInChar", trimSpaceInChar)
    def getConvertTimestampWithZoneToUTC: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "convertTimestampWithZoneToUTC",
        convertTimestampWithZoneToUTC
      )
    def getOpenTransactionWindow: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("openTransactionWindow", openTransactionWindow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ) extends zio.aws.databasemigration.model.OracleSettings.ReadOnly {
    override val addSupplementalLogging: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addSupplementalLogging())
        .map(value => value: BooleanOptional)
    override val archivedLogDestId: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archivedLogDestId())
        .map(value => value: IntegerOptional)
    override val additionalArchivedLogDestId: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalArchivedLogDestId())
        .map(value => value: IntegerOptional)
    override val extraArchivedLogDestIds: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extraArchivedLogDestIds())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
    override val allowSelectNestedTables: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowSelectNestedTables())
        .map(value => value: BooleanOptional)
    override val parallelAsmReadThreads: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelAsmReadThreads())
        .map(value => value: IntegerOptional)
    override val readAheadBlocks: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readAheadBlocks())
        .map(value => value: IntegerOptional)
    override val accessAlternateDirectly: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessAlternateDirectly())
        .map(value => value: BooleanOptional)
    override val useAlternateFolderForOnline: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useAlternateFolderForOnline())
        .map(value => value: BooleanOptional)
    override val oraclePathPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.oraclePathPrefix())
      .map(value => value: String)
    override val usePathPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usePathPrefix())
      .map(value => value: String)
    override val replacePathPrefix: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replacePathPrefix())
        .map(value => value: BooleanOptional)
    override val enableHomogenousTablespace: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableHomogenousTablespace())
        .map(value => value: BooleanOptional)
    override val directPathNoLog: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directPathNoLog())
        .map(value => value: BooleanOptional)
    override val archivedLogsOnly: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archivedLogsOnly())
        .map(value => value: BooleanOptional)
    override val asmPassword: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.asmPassword())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val asmServer: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.asmServer())
      .map(value => value: String)
    override val asmUser: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.asmUser())
      .map(value => value: String)
    override val charLengthSemantics
        : Optional[zio.aws.databasemigration.model.CharLengthSemantics] =
      zio.aws.core.internal
        .optionalFromNullable(impl.charLengthSemantics())
        .map(value =>
          zio.aws.databasemigration.model.CharLengthSemantics.wrap(value)
        )
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val directPathParallelLoad: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directPathParallelLoad())
        .map(value => value: BooleanOptional)
    override val failTasksOnLobTruncation: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failTasksOnLobTruncation())
        .map(value => value: BooleanOptional)
    override val numberDatatypeScale: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberDatatypeScale())
        .map(value => value: IntegerOptional)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val readTableSpaceName: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readTableSpaceName())
        .map(value => value: BooleanOptional)
    override val retryInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryInterval())
        .map(value => value: IntegerOptional)
    override val securityDbEncryption: Optional[SecretString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityDbEncryption())
        .map(value =>
          zio.aws.databasemigration.model.primitives.SecretString(value)
        )
    override val securityDbEncryptionName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityDbEncryptionName())
        .map(value => value: String)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val spatialDataOptionToGeoJsonFunctionName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spatialDataOptionToGeoJsonFunctionName())
        .map(value => value: String)
    override val standbyDelayTime: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standbyDelayTime())
        .map(value => value: IntegerOptional)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val useBFile: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.useBFile())
      .map(value => value: BooleanOptional)
    override val useDirectPathFullLoad: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDirectPathFullLoad())
        .map(value => value: BooleanOptional)
    override val useLogminerReader: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useLogminerReader())
        .map(value => value: BooleanOptional)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
    override val secretsManagerOracleAsmAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerOracleAsmAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerOracleAsmSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerOracleAsmSecretId())
        .map(value => value: String)
    override val trimSpaceInChar: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trimSpaceInChar())
        .map(value => value: BooleanOptional)
    override val convertTimestampWithZoneToUTC: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.convertTimestampWithZoneToUTC())
        .map(value => value: BooleanOptional)
    override val openTransactionWindow: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openTransactionWindow())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.OracleSettings
  ): zio.aws.databasemigration.model.OracleSettings.ReadOnly = new Wrapper(impl)
}
