package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait NestingLevelValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.NestingLevelValue
}
object NestingLevelValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.NestingLevelValue
  ): zio.aws.databasemigration.model.NestingLevelValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.ONE =>
      val r = one
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.NestingLevelValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.NestingLevelValue =
      software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.databasemigration.model.NestingLevelValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.NestingLevelValue =
      software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.NONE
  }
  case object one extends zio.aws.databasemigration.model.NestingLevelValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.NestingLevelValue =
      software.amazon.awssdk.services.databasemigration.model.NestingLevelValue.ONE
  }
}
