package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationInstanceResponse(
    replicationInstance: Optional[
      zio.aws.databasemigration.model.ReplicationInstance
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse = {
    import ModifyReplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse
      .builder()
      .optionallyWith(replicationInstance.map(value => value.buildAwsValue()))(
        _.replicationInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationInstanceResponse
      .wrap(buildAwsValue())
}
object ModifyReplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationInstanceResponse =
      zio.aws.databasemigration.model.ModifyReplicationInstanceResponse(
        replicationInstance.map(value => value.asEditable)
      )
    def replicationInstance
        : Optional[zio.aws.databasemigration.model.ReplicationInstance.ReadOnly]
    def getReplicationInstance: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = AwsError.unwrapOptionField("replicationInstance", replicationInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse
  ) extends zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly {
    override val replicationInstance: Optional[
      zio.aws.databasemigration.model.ReplicationInstance.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationInstance())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationInstance.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse
  ): zio.aws.databasemigration.model.ModifyReplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
