package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyReplicationInstanceRequest(
    replicationInstanceArn: String,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    replicationInstanceClass: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    replicationInstanceIdentifier: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest = {
    import ModifyReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object ModifyReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyReplicationInstanceRequest =
      zio.aws.databasemigration.model.ModifyReplicationInstanceRequest(
        replicationInstanceArn,
        allocatedStorage.map(value => value),
        applyImmediately.map(value => value),
        replicationInstanceClass.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        replicationInstanceIdentifier.map(value => value),
        networkType.map(value => value)
      )
    def replicationInstanceArn: String
    def allocatedStorage: Optional[IntegerOptional]
    def applyImmediately: Optional[Boolean]
    def replicationInstanceClass: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def preferredMaintenanceWindow: Optional[String]
    def multiAZ: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[Boolean]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def replicationInstanceIdentifier: Optional[String]
    def networkType: Optional[String]
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgrade)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val replicationInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceClass())
        .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val replicationInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceIdentifier())
        .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest
  ): zio.aws.databasemigration.model.ModifyReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
