package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  SecretString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ModifyEndpointRequest(
    endpointArn: String,
    endpointIdentifier: Optional[String] = Optional.Absent,
    endpointType: Optional[
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    extraConnectionAttributes: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    externalTableDefinition: Optional[String] = Optional.Absent,
    dynamoDbSettings: Optional[
      zio.aws.databasemigration.model.DynamoDbSettings
    ] = Optional.Absent,
    s3Settings: Optional[zio.aws.databasemigration.model.S3Settings] =
      Optional.Absent,
    dmsTransferSettings: Optional[
      zio.aws.databasemigration.model.DmsTransferSettings
    ] = Optional.Absent,
    mongoDbSettings: Optional[zio.aws.databasemigration.model.MongoDbSettings] =
      Optional.Absent,
    kinesisSettings: Optional[zio.aws.databasemigration.model.KinesisSettings] =
      Optional.Absent,
    kafkaSettings: Optional[zio.aws.databasemigration.model.KafkaSettings] =
      Optional.Absent,
    elasticsearchSettings: Optional[
      zio.aws.databasemigration.model.ElasticsearchSettings
    ] = Optional.Absent,
    neptuneSettings: Optional[zio.aws.databasemigration.model.NeptuneSettings] =
      Optional.Absent,
    redshiftSettings: Optional[
      zio.aws.databasemigration.model.RedshiftSettings
    ] = Optional.Absent,
    postgreSQLSettings: Optional[
      zio.aws.databasemigration.model.PostgreSQLSettings
    ] = Optional.Absent,
    mySQLSettings: Optional[zio.aws.databasemigration.model.MySQLSettings] =
      Optional.Absent,
    oracleSettings: Optional[zio.aws.databasemigration.model.OracleSettings] =
      Optional.Absent,
    sybaseSettings: Optional[zio.aws.databasemigration.model.SybaseSettings] =
      Optional.Absent,
    microsoftSQLServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings
    ] = Optional.Absent,
    ibmDb2Settings: Optional[zio.aws.databasemigration.model.IBMDb2Settings] =
      Optional.Absent,
    docDbSettings: Optional[zio.aws.databasemigration.model.DocDbSettings] =
      Optional.Absent,
    redisSettings: Optional[zio.aws.databasemigration.model.RedisSettings] =
      Optional.Absent,
    exactSettings: Optional[BooleanOptional] = Optional.Absent,
    gcpMySQLSettings: Optional[
      zio.aws.databasemigration.model.GcpMySQLSettings
    ] = Optional.Absent,
    timestreamSettings: Optional[
      zio.aws.databasemigration.model.TimestreamSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest = {
    import ModifyEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .optionallyWith(endpointIdentifier.map(value => value: java.lang.String))(
        _.endpointIdentifier
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        extraConnectionAttributes.map(value => value: java.lang.String)
      )(_.extraConnectionAttributes)
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(sslMode.map(value => value.unwrap))(_.sslMode)
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        externalTableDefinition.map(value => value: java.lang.String)
      )(_.externalTableDefinition)
      .optionallyWith(dynamoDbSettings.map(value => value.buildAwsValue()))(
        _.dynamoDbSettings
      )
      .optionallyWith(s3Settings.map(value => value.buildAwsValue()))(
        _.s3Settings
      )
      .optionallyWith(dmsTransferSettings.map(value => value.buildAwsValue()))(
        _.dmsTransferSettings
      )
      .optionallyWith(mongoDbSettings.map(value => value.buildAwsValue()))(
        _.mongoDbSettings
      )
      .optionallyWith(kinesisSettings.map(value => value.buildAwsValue()))(
        _.kinesisSettings
      )
      .optionallyWith(kafkaSettings.map(value => value.buildAwsValue()))(
        _.kafkaSettings
      )
      .optionallyWith(
        elasticsearchSettings.map(value => value.buildAwsValue())
      )(_.elasticsearchSettings)
      .optionallyWith(neptuneSettings.map(value => value.buildAwsValue()))(
        _.neptuneSettings
      )
      .optionallyWith(redshiftSettings.map(value => value.buildAwsValue()))(
        _.redshiftSettings
      )
      .optionallyWith(postgreSQLSettings.map(value => value.buildAwsValue()))(
        _.postgreSQLSettings
      )
      .optionallyWith(mySQLSettings.map(value => value.buildAwsValue()))(
        _.mySQLSettings
      )
      .optionallyWith(oracleSettings.map(value => value.buildAwsValue()))(
        _.oracleSettings
      )
      .optionallyWith(sybaseSettings.map(value => value.buildAwsValue()))(
        _.sybaseSettings
      )
      .optionallyWith(
        microsoftSQLServerSettings.map(value => value.buildAwsValue())
      )(_.microsoftSQLServerSettings)
      .optionallyWith(ibmDb2Settings.map(value => value.buildAwsValue()))(
        _.ibmDb2Settings
      )
      .optionallyWith(docDbSettings.map(value => value.buildAwsValue()))(
        _.docDbSettings
      )
      .optionallyWith(redisSettings.map(value => value.buildAwsValue()))(
        _.redisSettings
      )
      .optionallyWith(exactSettings.map(value => value: java.lang.Boolean))(
        _.exactSettings
      )
      .optionallyWith(gcpMySQLSettings.map(value => value.buildAwsValue()))(
        _.gcpMySQLSettings
      )
      .optionallyWith(timestreamSettings.map(value => value.buildAwsValue()))(
        _.timestreamSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyEndpointRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyEndpointRequest.wrap(buildAwsValue())
}
object ModifyEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ModifyEndpointRequest =
      zio.aws.databasemigration.model.ModifyEndpointRequest(
        endpointArn,
        endpointIdentifier.map(value => value),
        endpointType.map(value => value),
        engineName.map(value => value),
        username.map(value => value),
        password.map(value => value),
        serverName.map(value => value),
        port.map(value => value),
        databaseName.map(value => value),
        extraConnectionAttributes.map(value => value),
        certificateArn.map(value => value),
        sslMode.map(value => value),
        serviceAccessRoleArn.map(value => value),
        externalTableDefinition.map(value => value),
        dynamoDbSettings.map(value => value.asEditable),
        s3Settings.map(value => value.asEditable),
        dmsTransferSettings.map(value => value.asEditable),
        mongoDbSettings.map(value => value.asEditable),
        kinesisSettings.map(value => value.asEditable),
        kafkaSettings.map(value => value.asEditable),
        elasticsearchSettings.map(value => value.asEditable),
        neptuneSettings.map(value => value.asEditable),
        redshiftSettings.map(value => value.asEditable),
        postgreSQLSettings.map(value => value.asEditable),
        mySQLSettings.map(value => value.asEditable),
        oracleSettings.map(value => value.asEditable),
        sybaseSettings.map(value => value.asEditable),
        microsoftSQLServerSettings.map(value => value.asEditable),
        ibmDb2Settings.map(value => value.asEditable),
        docDbSettings.map(value => value.asEditable),
        redisSettings.map(value => value.asEditable),
        exactSettings.map(value => value),
        gcpMySQLSettings.map(value => value.asEditable),
        timestreamSettings.map(value => value.asEditable)
      )
    def endpointArn: String
    def endpointIdentifier: Optional[String]
    def endpointType
        : Optional[zio.aws.databasemigration.model.ReplicationEndpointTypeValue]
    def engineName: Optional[String]
    def username: Optional[String]
    def password: Optional[SecretString]
    def serverName: Optional[String]
    def port: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def extraConnectionAttributes: Optional[String]
    def certificateArn: Optional[String]
    def sslMode: Optional[zio.aws.databasemigration.model.DmsSslModeValue]
    def serviceAccessRoleArn: Optional[String]
    def externalTableDefinition: Optional[String]
    def dynamoDbSettings
        : Optional[zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly]
    def s3Settings
        : Optional[zio.aws.databasemigration.model.S3Settings.ReadOnly]
    def dmsTransferSettings
        : Optional[zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly]
    def mongoDbSettings
        : Optional[zio.aws.databasemigration.model.MongoDbSettings.ReadOnly]
    def kinesisSettings
        : Optional[zio.aws.databasemigration.model.KinesisSettings.ReadOnly]
    def kafkaSettings
        : Optional[zio.aws.databasemigration.model.KafkaSettings.ReadOnly]
    def elasticsearchSettings: Optional[
      zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly
    ]
    def neptuneSettings
        : Optional[zio.aws.databasemigration.model.NeptuneSettings.ReadOnly]
    def redshiftSettings
        : Optional[zio.aws.databasemigration.model.RedshiftSettings.ReadOnly]
    def postgreSQLSettings
        : Optional[zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly]
    def mySQLSettings
        : Optional[zio.aws.databasemigration.model.MySQLSettings.ReadOnly]
    def oracleSettings
        : Optional[zio.aws.databasemigration.model.OracleSettings.ReadOnly]
    def sybaseSettings
        : Optional[zio.aws.databasemigration.model.SybaseSettings.ReadOnly]
    def microsoftSQLServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ]
    def ibmDb2Settings
        : Optional[zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly]
    def docDbSettings
        : Optional[zio.aws.databasemigration.model.DocDbSettings.ReadOnly]
    def redisSettings
        : Optional[zio.aws.databasemigration.model.RedisSettings.ReadOnly]
    def exactSettings: Optional[BooleanOptional]
    def gcpMySQLSettings
        : Optional[zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly]
    def timestreamSettings
        : Optional[zio.aws.databasemigration.model.TimestreamSettings.ReadOnly]
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
    def getEndpointIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointIdentifier", endpointIdentifier)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getExtraConnectionAttributes: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("extraConnectionAttributes", extraConnectionAttributes)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getSslMode
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.DmsSslModeValue] =
      AwsError.unwrapOptionField("sslMode", sslMode)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getExternalTableDefinition: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("externalTableDefinition", externalTableDefinition)
    def getDynamoDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dynamoDbSettings", dynamoDbSettings)
    def getS3Settings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.S3Settings.ReadOnly
    ] = AwsError.unwrapOptionField("s3Settings", s3Settings)
    def getDmsTransferSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly
    ] = AwsError.unwrapOptionField("dmsTransferSettings", dmsTransferSettings)
    def getMongoDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MongoDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mongoDbSettings", mongoDbSettings)
    def getKinesisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KinesisSettings.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisSettings", kinesisSettings)
    def getKafkaSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.KafkaSettings.ReadOnly
    ] = AwsError.unwrapOptionField("kafkaSettings", kafkaSettings)
    def getElasticsearchSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly
    ] =
      AwsError.unwrapOptionField("elasticsearchSettings", elasticsearchSettings)
    def getNeptuneSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.NeptuneSettings.ReadOnly
    ] = AwsError.unwrapOptionField("neptuneSettings", neptuneSettings)
    def getRedshiftSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedshiftSettings.ReadOnly
    ] = AwsError.unwrapOptionField("redshiftSettings", redshiftSettings)
    def getPostgreSQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("postgreSQLSettings", postgreSQLSettings)
    def getMySQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MySQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mySQLSettings", mySQLSettings)
    def getOracleSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.OracleSettings.ReadOnly
    ] = AwsError.unwrapOptionField("oracleSettings", oracleSettings)
    def getSybaseSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SybaseSettings.ReadOnly
    ] = AwsError.unwrapOptionField("sybaseSettings", sybaseSettings)
    def getMicrosoftSQLServerSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "microsoftSQLServerSettings",
      microsoftSQLServerSettings
    )
    def getIbmDb2Settings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly
    ] = AwsError.unwrapOptionField("ibmDb2Settings", ibmDb2Settings)
    def getDocDbSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.DocDbSettings.ReadOnly
    ] = AwsError.unwrapOptionField("docDbSettings", docDbSettings)
    def getRedisSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RedisSettings.ReadOnly
    ] = AwsError.unwrapOptionField("redisSettings", redisSettings)
    def getExactSettings: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("exactSettings", exactSettings)
    def getGcpMySQLSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly
    ] = AwsError.unwrapOptionField("gcpMySQLSettings", gcpMySQLSettings)
    def getTimestreamSettings: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.TimestreamSettings.ReadOnly
    ] = AwsError.unwrapOptionField("timestreamSettings", timestreamSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest
  ) extends zio.aws.databasemigration.model.ModifyEndpointRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
    override val endpointIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointIdentifier())
      .map(value => value: String)
    override val endpointType: Optional[
      zio.aws.databasemigration.model.ReplicationEndpointTypeValue
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationEndpointTypeValue.wrap(value)
      )
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val extraConnectionAttributes: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extraConnectionAttributes())
        .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val sslMode
        : Optional[zio.aws.databasemigration.model.DmsSslModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sslMode())
        .map(value =>
          zio.aws.databasemigration.model.DmsSslModeValue.wrap(value)
        )
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val externalTableDefinition: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalTableDefinition())
        .map(value => value: String)
    override val dynamoDbSettings
        : Optional[zio.aws.databasemigration.model.DynamoDbSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamoDbSettings())
        .map(value =>
          zio.aws.databasemigration.model.DynamoDbSettings.wrap(value)
        )
    override val s3Settings
        : Optional[zio.aws.databasemigration.model.S3Settings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Settings())
        .map(value => zio.aws.databasemigration.model.S3Settings.wrap(value))
    override val dmsTransferSettings: Optional[
      zio.aws.databasemigration.model.DmsTransferSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dmsTransferSettings())
      .map(value =>
        zio.aws.databasemigration.model.DmsTransferSettings.wrap(value)
      )
    override val mongoDbSettings
        : Optional[zio.aws.databasemigration.model.MongoDbSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mongoDbSettings())
        .map(value =>
          zio.aws.databasemigration.model.MongoDbSettings.wrap(value)
        )
    override val kinesisSettings
        : Optional[zio.aws.databasemigration.model.KinesisSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kinesisSettings())
        .map(value =>
          zio.aws.databasemigration.model.KinesisSettings.wrap(value)
        )
    override val kafkaSettings
        : Optional[zio.aws.databasemigration.model.KafkaSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kafkaSettings())
        .map(value => zio.aws.databasemigration.model.KafkaSettings.wrap(value))
    override val elasticsearchSettings: Optional[
      zio.aws.databasemigration.model.ElasticsearchSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchSettings())
      .map(value =>
        zio.aws.databasemigration.model.ElasticsearchSettings.wrap(value)
      )
    override val neptuneSettings
        : Optional[zio.aws.databasemigration.model.NeptuneSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.neptuneSettings())
        .map(value =>
          zio.aws.databasemigration.model.NeptuneSettings.wrap(value)
        )
    override val redshiftSettings
        : Optional[zio.aws.databasemigration.model.RedshiftSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redshiftSettings())
        .map(value =>
          zio.aws.databasemigration.model.RedshiftSettings.wrap(value)
        )
    override val postgreSQLSettings: Optional[
      zio.aws.databasemigration.model.PostgreSQLSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.postgreSQLSettings())
      .map(value =>
        zio.aws.databasemigration.model.PostgreSQLSettings.wrap(value)
      )
    override val mySQLSettings
        : Optional[zio.aws.databasemigration.model.MySQLSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mySQLSettings())
        .map(value => zio.aws.databasemigration.model.MySQLSettings.wrap(value))
    override val oracleSettings
        : Optional[zio.aws.databasemigration.model.OracleSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oracleSettings())
        .map(value =>
          zio.aws.databasemigration.model.OracleSettings.wrap(value)
        )
    override val sybaseSettings
        : Optional[zio.aws.databasemigration.model.SybaseSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sybaseSettings())
        .map(value =>
          zio.aws.databasemigration.model.SybaseSettings.wrap(value)
        )
    override val microsoftSQLServerSettings: Optional[
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.microsoftSQLServerSettings())
      .map(value =>
        zio.aws.databasemigration.model.MicrosoftSQLServerSettings.wrap(value)
      )
    override val ibmDb2Settings
        : Optional[zio.aws.databasemigration.model.IBMDb2Settings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ibmDb2Settings())
        .map(value =>
          zio.aws.databasemigration.model.IBMDb2Settings.wrap(value)
        )
    override val docDbSettings
        : Optional[zio.aws.databasemigration.model.DocDbSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.docDbSettings())
        .map(value => zio.aws.databasemigration.model.DocDbSettings.wrap(value))
    override val redisSettings
        : Optional[zio.aws.databasemigration.model.RedisSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.redisSettings())
        .map(value => zio.aws.databasemigration.model.RedisSettings.wrap(value))
    override val exactSettings: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exactSettings())
        .map(value => value: BooleanOptional)
    override val gcpMySQLSettings
        : Optional[zio.aws.databasemigration.model.GcpMySQLSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gcpMySQLSettings())
        .map(value =>
          zio.aws.databasemigration.model.GcpMySQLSettings.wrap(value)
        )
    override val timestreamSettings: Optional[
      zio.aws.databasemigration.model.TimestreamSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timestreamSettings())
      .map(value =>
        zio.aws.databasemigration.model.TimestreamSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest
  ): zio.aws.databasemigration.model.ModifyEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
