package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait KafkaSecurityProtocol {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol
}
object KafkaSecurityProtocol {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol
  ): zio.aws.databasemigration.model.KafkaSecurityProtocol = value match {
    case software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.PLAINTEXT =>
      val r = plaintext
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SSL_AUTHENTICATION =>
      val r = `ssl-authentication`
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SSL_ENCRYPTION =>
      val r = `ssl-encryption`
      r
    case software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SASL_SSL =>
      val r = `sasl-ssl`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.KafkaSecurityProtocol {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol =
      software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object plaintext
      extends zio.aws.databasemigration.model.KafkaSecurityProtocol {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol =
      software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.PLAINTEXT
  }
  case object `ssl-authentication`
      extends zio.aws.databasemigration.model.KafkaSecurityProtocol {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol =
      software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SSL_AUTHENTICATION
  }
  case object `ssl-encryption`
      extends zio.aws.databasemigration.model.KafkaSecurityProtocol {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol =
      software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SSL_ENCRYPTION
  }
  case object `sasl-ssl`
      extends zio.aws.databasemigration.model.KafkaSecurityProtocol {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol =
      software.amazon.awssdk.services.databasemigration.model.KafkaSecurityProtocol.SASL_SSL
  }
}
