package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.LongOptional
import scala.jdk.CollectionConverters.*
final case class FleetAdvisorSchemaObjectResponse(
    schemaId: Optional[String] = Optional.Absent,
    objectType: Optional[String] = Optional.Absent,
    numberOfObjects: Optional[LongOptional] = Optional.Absent,
    codeLineCount: Optional[LongOptional] = Optional.Absent,
    codeSize: Optional[LongOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaObjectResponse = {
    import FleetAdvisorSchemaObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaObjectResponse
      .builder()
      .optionallyWith(schemaId.map(value => value: java.lang.String))(
        _.schemaId
      )
      .optionallyWith(objectType.map(value => value: java.lang.String))(
        _.objectType
      )
      .optionallyWith(numberOfObjects.map(value => value: java.lang.Long))(
        _.numberOfObjects
      )
      .optionallyWith(codeLineCount.map(value => value: java.lang.Long))(
        _.codeLineCount
      )
      .optionallyWith(codeSize.map(value => value: java.lang.Long))(_.codeSize)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly =
    zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse
      .wrap(buildAwsValue())
}
object FleetAdvisorSchemaObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse =
      zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse(
        schemaId.map(value => value),
        objectType.map(value => value),
        numberOfObjects.map(value => value),
        codeLineCount.map(value => value),
        codeSize.map(value => value)
      )
    def schemaId: Optional[String]
    def objectType: Optional[String]
    def numberOfObjects: Optional[LongOptional]
    def codeLineCount: Optional[LongOptional]
    def codeSize: Optional[LongOptional]
    def getSchemaId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaId", schemaId)
    def getObjectType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("objectType", objectType)
    def getNumberOfObjects: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("numberOfObjects", numberOfObjects)
    def getCodeLineCount: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("codeLineCount", codeLineCount)
    def getCodeSize: ZIO[Any, AwsError, LongOptional] =
      AwsError.unwrapOptionField("codeSize", codeSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaObjectResponse
  ) extends zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly {
    override val schemaId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaId())
      .map(value => value: String)
    override val objectType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.objectType())
      .map(value => value: String)
    override val numberOfObjects: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfObjects())
      .map(value => value: LongOptional)
    override val codeLineCount: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.codeLineCount())
      .map(value => value: LongOptional)
    override val codeSize: Optional[LongOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.codeSize())
      .map(value => value: LongOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.FleetAdvisorSchemaObjectResponse
  ): zio.aws.databasemigration.model.FleetAdvisorSchemaObjectResponse.ReadOnly =
    new Wrapper(impl)
}
