package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReplicationTaskAssessmentResultsRequest(
    replicationTaskArn: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest = {
    import DescribeReplicationTaskAssessmentResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
      .builder()
      .optionallyWith(replicationTaskArn.map(value => value: java.lang.String))(
        _.replicationTaskArn
      )
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
      .wrap(buildAwsValue())
}
object DescribeReplicationTaskAssessmentResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest =
      zio.aws.databasemigration.model
        .DescribeReplicationTaskAssessmentResultsRequest(
          replicationTaskArn.map(value => value),
          maxRecords.map(value => value),
          marker.map(value => value)
        )
    def replicationTaskArn: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReplicationTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationTaskArn", replicationTaskArn)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ) extends zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.ReadOnly {
    override val replicationTaskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskArn())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest
  ): zio.aws.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.ReadOnly =
    new Wrapper(impl)
}
