package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorLsaAnalysisResponse(
    analysis: Optional[
      Iterable[zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse = {
    import DescribeFleetAdvisorLsaAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse
      .builder()
      .optionallyWith(
        analysis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.analysis)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorLsaAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse =
      zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse(
        analysis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def analysis: Optional[List[
      zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getAnalysis: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("analysis", analysis)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly {
    override val analysis: Optional[List[
      zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.analysis())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.FleetAdvisorLsaAnalysisResponse
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
