package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeFleetAdvisorCollectorsResponse(
    collectors: Optional[
      Iterable[zio.aws.databasemigration.model.CollectorResponse]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse = {
    import DescribeFleetAdvisorCollectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse
      .builder()
      .optionallyWith(
        collectors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.collectors)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse
      .wrap(buildAwsValue())
}
object DescribeFleetAdvisorCollectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse =
      zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse(
        collectors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def collectors: Optional[
      List[zio.aws.databasemigration.model.CollectorResponse.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getCollectors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.CollectorResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("collectors", collectors)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse
  ) extends zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly {
    override val collectors: Optional[
      List[zio.aws.databasemigration.model.CollectorResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.collectors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.CollectorResponse.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse
  ): zio.aws.databasemigration.model.DescribeFleetAdvisorCollectorsResponse.ReadOnly =
    new Wrapper(impl)
}
