package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointSettingsRequest(
    engineName: String,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest = {
    import DescribeEndpointSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest
      .builder()
      .engineName(engineName: java.lang.String)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEndpointSettingsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribeEndpointSettingsRequest
      .wrap(buildAwsValue())
}
object DescribeEndpointSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEndpointSettingsRequest =
      zio.aws.databasemigration.model.DescribeEndpointSettingsRequest(
        engineName,
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def engineName: String
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getEngineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest
  ) extends zio.aws.databasemigration.model.DescribeEndpointSettingsRequest.ReadOnly {
    override val engineName: String = impl.engineName(): String
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest
  ): zio.aws.databasemigration.model.DescribeEndpointSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
