package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConnectionsResponse(
    marker: Optional[String] = Optional.Absent,
    connections: Optional[
      Iterable[zio.aws.databasemigration.model.Connection]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse = {
    import DescribeConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeConnectionsResponse =
      zio.aws.databasemigration.model.DescribeConnectionsResponse(
        marker.map(value => value),
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def connections
        : Optional[List[zio.aws.databasemigration.model.Connection.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ) extends zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val connections
        : Optional[List[zio.aws.databasemigration.model.Connection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Connection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse
  ): zio.aws.databasemigration.model.DescribeConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
