package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteConnectionResponse(
    connection: Optional[zio.aws.databasemigration.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse = {
    import DeleteConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteConnectionResponse =
      zio.aws.databasemigration.model
        .DeleteConnectionResponse(connection.map(value => value.asEditable))
    def connection
        : Optional[zio.aws.databasemigration.model.Connection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Connection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse
  ) extends zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.databasemigration.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.databasemigration.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse
  ): zio.aws.databasemigration.model.DeleteConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
