package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait DatePartitionDelimiterValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue
}
object DatePartitionDelimiterValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue
  ): zio.aws.databasemigration.model.DatePartitionDelimiterValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.SLASH =>
      val r = SLASH
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.UNDERSCORE =>
      val r = UNDERSCORE
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.DASH =>
      val r = DASH
      r
    case software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.DatePartitionDelimiterValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.UNKNOWN_TO_SDK_VERSION
  }
  case object SLASH
      extends zio.aws.databasemigration.model.DatePartitionDelimiterValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.SLASH
  }
  case object UNDERSCORE
      extends zio.aws.databasemigration.model.DatePartitionDelimiterValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.UNDERSCORE
  }
  case object DASH
      extends zio.aws.databasemigration.model.DatePartitionDelimiterValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.DASH
  }
  case object NONE
      extends zio.aws.databasemigration.model.DatePartitionDelimiterValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue =
      software.amazon.awssdk.services.databasemigration.model.DatePartitionDelimiterValue.NONE
  }
}
