package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateReplicationConfigRequest(
    replicationConfigIdentifier: String,
    sourceEndpointArn: String,
    targetEndpointArn: String,
    computeConfig: zio.aws.databasemigration.model.ComputeConfig,
    replicationType: zio.aws.databasemigration.model.MigrationTypeValue,
    tableMappings: String,
    replicationSettings: Optional[String] = Optional.Absent,
    supplementalSettings: Optional[String] = Optional.Absent,
    resourceIdentifier: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest = {
    import CreateReplicationConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest
      .builder()
      .replicationConfigIdentifier(
        replicationConfigIdentifier: java.lang.String
      )
      .sourceEndpointArn(sourceEndpointArn: java.lang.String)
      .targetEndpointArn(targetEndpointArn: java.lang.String)
      .computeConfig(computeConfig.buildAwsValue())
      .replicationType(replicationType.unwrap)
      .tableMappings(tableMappings: java.lang.String)
      .optionallyWith(
        replicationSettings.map(value => value: java.lang.String)
      )(_.replicationSettings)
      .optionallyWith(
        supplementalSettings.map(value => value: java.lang.String)
      )(_.supplementalSettings)
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationConfigRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationConfigRequest
      .wrap(buildAwsValue())
}
object CreateReplicationConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationConfigRequest =
      zio.aws.databasemigration.model.CreateReplicationConfigRequest(
        replicationConfigIdentifier,
        sourceEndpointArn,
        targetEndpointArn,
        computeConfig.asEditable,
        replicationType,
        tableMappings,
        replicationSettings.map(value => value),
        supplementalSettings.map(value => value),
        resourceIdentifier.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationConfigIdentifier: String
    def sourceEndpointArn: String
    def targetEndpointArn: String
    def computeConfig: zio.aws.databasemigration.model.ComputeConfig.ReadOnly
    def replicationType: zio.aws.databasemigration.model.MigrationTypeValue
    def tableMappings: String
    def replicationSettings: Optional[String]
    def supplementalSettings: Optional[String]
    def resourceIdentifier: Optional[String]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def getReplicationConfigIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationConfigIdentifier)
    def getSourceEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceEndpointArn)
    def getTargetEndpointArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetEndpointArn)
    def getComputeConfig: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.ComputeConfig.ReadOnly
    ] = ZIO.succeed(computeConfig)
    def getReplicationType: ZIO[
      Any,
      Nothing,
      zio.aws.databasemigration.model.MigrationTypeValue
    ] = ZIO.succeed(replicationType)
    def getTableMappings: ZIO[Any, Nothing, String] = ZIO.succeed(tableMappings)
    def getReplicationSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replicationSettings", replicationSettings)
    def getSupplementalSettings: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supplementalSettings", supplementalSettings)
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationConfigRequest.ReadOnly {
    override val replicationConfigIdentifier: String =
      impl.replicationConfigIdentifier(): String
    override val sourceEndpointArn: String = impl.sourceEndpointArn(): String
    override val targetEndpointArn: String = impl.targetEndpointArn(): String
    override val computeConfig
        : zio.aws.databasemigration.model.ComputeConfig.ReadOnly =
      zio.aws.databasemigration.model.ComputeConfig.wrap(impl.computeConfig())
    override val replicationType
        : zio.aws.databasemigration.model.MigrationTypeValue =
      zio.aws.databasemigration.model.MigrationTypeValue
        .wrap(impl.replicationType())
    override val tableMappings: String = impl.tableMappings(): String
    override val replicationSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSettings())
      .map(value => value: String)
    override val supplementalSettings: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.supplementalSettings())
      .map(value => value: String)
    override val resourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => value: String)
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest
  ): zio.aws.databasemigration.model.CreateReplicationConfigRequest.ReadOnly =
    new Wrapper(impl)
}
