package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters.*
final case class CollectorHealthCheck(
    collectorStatus: Optional[zio.aws.databasemigration.model.CollectorStatus] =
      Optional.Absent,
    localCollectorS3Access: Optional[BooleanOptional] = Optional.Absent,
    webCollectorS3Access: Optional[BooleanOptional] = Optional.Absent,
    webCollectorGrantedRoleBasedAccess: Optional[BooleanOptional] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck = {
    import CollectorHealthCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck
      .builder()
      .optionallyWith(collectorStatus.map(value => value.unwrap))(
        _.collectorStatus
      )
      .optionallyWith(
        localCollectorS3Access.map(value => value: java.lang.Boolean)
      )(_.localCollectorS3Access)
      .optionallyWith(
        webCollectorS3Access.map(value => value: java.lang.Boolean)
      )(_.webCollectorS3Access)
      .optionallyWith(
        webCollectorGrantedRoleBasedAccess.map(value =>
          value: java.lang.Boolean
        )
      )(_.webCollectorGrantedRoleBasedAccess)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly =
    zio.aws.databasemigration.model.CollectorHealthCheck.wrap(buildAwsValue())
}
object CollectorHealthCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CollectorHealthCheck =
      zio.aws.databasemigration.model.CollectorHealthCheck(
        collectorStatus.map(value => value),
        localCollectorS3Access.map(value => value),
        webCollectorS3Access.map(value => value),
        webCollectorGrantedRoleBasedAccess.map(value => value)
      )
    def collectorStatus
        : Optional[zio.aws.databasemigration.model.CollectorStatus]
    def localCollectorS3Access: Optional[BooleanOptional]
    def webCollectorS3Access: Optional[BooleanOptional]
    def webCollectorGrantedRoleBasedAccess: Optional[BooleanOptional]
    def getCollectorStatus
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.CollectorStatus] =
      AwsError.unwrapOptionField("collectorStatus", collectorStatus)
    def getLocalCollectorS3Access: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "localCollectorS3Access",
        localCollectorS3Access
      )
    def getWebCollectorS3Access: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("webCollectorS3Access", webCollectorS3Access)
    def getWebCollectorGrantedRoleBasedAccess
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "webCollectorGrantedRoleBasedAccess",
      webCollectorGrantedRoleBasedAccess
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck
  ) extends zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly {
    override val collectorStatus
        : Optional[zio.aws.databasemigration.model.CollectorStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectorStatus())
        .map(value =>
          zio.aws.databasemigration.model.CollectorStatus.wrap(value)
        )
    override val localCollectorS3Access: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localCollectorS3Access())
        .map(value => value: BooleanOptional)
    override val webCollectorS3Access: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webCollectorS3Access())
        .map(value => value: BooleanOptional)
    override val webCollectorGrantedRoleBasedAccess: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webCollectorGrantedRoleBasedAccess())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CollectorHealthCheck
  ): zio.aws.databasemigration.model.CollectorHealthCheck.ReadOnly =
    new Wrapper(impl)
}
