package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait AuthMechanismValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue
}
object AuthMechanismValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue
  ): zio.aws.databasemigration.model.AuthMechanismValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.MONGODB_CR =>
      val r = mongodb_cr
      r
    case software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.SCRAM_SHA_1 =>
      val r = scram_sha_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.AuthMechanismValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue =
      software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.UNKNOWN_TO_SDK_VERSION
  }
  case object default
      extends zio.aws.databasemigration.model.AuthMechanismValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue =
      software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.DEFAULT
  }
  case object mongodb_cr
      extends zio.aws.databasemigration.model.AuthMechanismValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue =
      software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.MONGODB_CR
  }
  case object scram_sha_1
      extends zio.aws.databasemigration.model.AuthMechanismValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue =
      software.amazon.awssdk.services.databasemigration.model.AuthMechanismValue.SCRAM_SHA_1
  }
}
