package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddTagsToResourceRequest(
    resourceArn: String,
    tags: Iterable[zio.aws.databasemigration.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.AddTagsToResourceRequest.ReadOnly =
    zio.aws.databasemigration.model.AddTagsToResourceRequest
      .wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.AddTagsToResourceRequest =
      zio.aws.databasemigration.model.AddTagsToResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: String
    def tags: List[zio.aws.databasemigration.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest
  ) extends zio.aws.databasemigration.model.AddTagsToResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: List[zio.aws.databasemigration.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.databasemigration.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest
  ): zio.aws.databasemigration.model.AddTagsToResourceRequest.ReadOnly =
    new Wrapper(impl)
}
