package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TestConnectionResponse(
    connection: Optional[zio.aws.databasemigration.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse = {
    import TestConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly =
    zio.aws.databasemigration.model.TestConnectionResponse.wrap(buildAwsValue())
}
object TestConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TestConnectionResponse =
      zio.aws.databasemigration.model
        .TestConnectionResponse(connection.map(value => value.asEditable))
    def connection
        : Optional[zio.aws.databasemigration.model.Connection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Connection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse
  ) extends zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.databasemigration.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.databasemigration.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse
  ): zio.aws.databasemigration.model.TestConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
