package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestConnectionRequest(
    replicationInstanceArn: String,
    endpointArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest = {
    import TestConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .endpointArn(endpointArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.TestConnectionRequest.ReadOnly =
    zio.aws.databasemigration.model.TestConnectionRequest.wrap(buildAwsValue())
}
object TestConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.TestConnectionRequest =
      zio.aws.databasemigration.model
        .TestConnectionRequest(replicationInstanceArn, endpointArn)
    def replicationInstanceArn: String
    def endpointArn: String
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest
  ) extends zio.aws.databasemigration.model.TestConnectionRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
    override val endpointArn: String = impl.endpointArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest
  ): zio.aws.databasemigration.model.TestConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
