package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartReplicationTaskResponse(
    replicationTask: Optional[zio.aws.databasemigration.model.ReplicationTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse = {
    import StartReplicationTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse
      .builder()
      .optionallyWith(replicationTask.map(value => value.buildAwsValue()))(
        _.replicationTask
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly =
    zio.aws.databasemigration.model.StartReplicationTaskResponse
      .wrap(buildAwsValue())
}
object StartReplicationTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartReplicationTaskResponse =
      zio.aws.databasemigration.model.StartReplicationTaskResponse(
        replicationTask.map(value => value.asEditable)
      )
    def replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly]
    def getReplicationTask: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTask.ReadOnly
    ] = AwsError.unwrapOptionField("replicationTask", replicationTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse
  ) extends zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly {
    override val replicationTask
        : Optional[zio.aws.databasemigration.model.ReplicationTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTask())
        .map(value =>
          zio.aws.databasemigration.model.ReplicationTask.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse
  ): zio.aws.databasemigration.model.StartReplicationTaskResponse.ReadOnly =
    new Wrapper(impl)
}
