package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartReplicationTaskAssessmentRunRequest(
    replicationTaskArn: String,
    serviceAccessRoleArn: String,
    resultLocationBucket: String,
    resultLocationFolder: Optional[String] = Optional.Absent,
    resultEncryptionMode: Optional[String] = Optional.Absent,
    resultKmsKeyArn: Optional[String] = Optional.Absent,
    assessmentRunName: String,
    includeOnly: Optional[Iterable[String]] = Optional.Absent,
    exclude: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest = {
    import StartReplicationTaskAssessmentRunRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest
      .builder()
      .replicationTaskArn(replicationTaskArn: java.lang.String)
      .serviceAccessRoleArn(serviceAccessRoleArn: java.lang.String)
      .resultLocationBucket(resultLocationBucket: java.lang.String)
      .optionallyWith(
        resultLocationFolder.map(value => value: java.lang.String)
      )(_.resultLocationFolder)
      .optionallyWith(
        resultEncryptionMode.map(value => value: java.lang.String)
      )(_.resultEncryptionMode)
      .optionallyWith(resultKmsKeyArn.map(value => value: java.lang.String))(
        _.resultKmsKeyArn
      )
      .assessmentRunName(assessmentRunName: java.lang.String)
      .optionallyWith(
        includeOnly.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.includeOnly)
      .optionallyWith(
        exclude.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exclude)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest.ReadOnly =
    zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest
      .wrap(buildAwsValue())
}
object StartReplicationTaskAssessmentRunRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest =
      zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest(
        replicationTaskArn,
        serviceAccessRoleArn,
        resultLocationBucket,
        resultLocationFolder.map(value => value),
        resultEncryptionMode.map(value => value),
        resultKmsKeyArn.map(value => value),
        assessmentRunName,
        includeOnly.map(value => value),
        exclude.map(value => value)
      )
    def replicationTaskArn: String
    def serviceAccessRoleArn: String
    def resultLocationBucket: String
    def resultLocationFolder: Optional[String]
    def resultEncryptionMode: Optional[String]
    def resultKmsKeyArn: Optional[String]
    def assessmentRunName: String
    def includeOnly: Optional[List[String]]
    def exclude: Optional[List[String]]
    def getReplicationTaskArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationTaskArn)
    def getServiceAccessRoleArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(serviceAccessRoleArn)
    def getResultLocationBucket: ZIO[Any, Nothing, String] =
      ZIO.succeed(resultLocationBucket)
    def getResultLocationFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultLocationFolder", resultLocationFolder)
    def getResultEncryptionMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultEncryptionMode", resultEncryptionMode)
    def getResultKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resultKmsKeyArn", resultKmsKeyArn)
    def getAssessmentRunName: ZIO[Any, Nothing, String] =
      ZIO.succeed(assessmentRunName)
    def getIncludeOnly: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("includeOnly", includeOnly)
    def getExclude: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("exclude", exclude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ) extends zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest.ReadOnly {
    override val replicationTaskArn: String = impl.replicationTaskArn(): String
    override val serviceAccessRoleArn: String =
      impl.serviceAccessRoleArn(): String
    override val resultLocationBucket: String =
      impl.resultLocationBucket(): String
    override val resultLocationFolder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultLocationFolder())
      .map(value => value: String)
    override val resultEncryptionMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultEncryptionMode())
      .map(value => value: String)
    override val resultKmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resultKmsKeyArn())
      .map(value => value: String)
    override val assessmentRunName: String = impl.assessmentRunName(): String
    override val includeOnly: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.includeOnly())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val exclude: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.exclude())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest
  ): zio.aws.databasemigration.model.StartReplicationTaskAssessmentRunRequest.ReadOnly =
    new Wrapper(impl)
}
