package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.SourceType
  ): zio.aws.databasemigration.model.SourceType = value match {
    case software.amazon.awssdk.services.databasemigration.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.SourceType.REPLICATION_INSTANCE =>
      val r = `replication-instance`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SourceType =
      software.amazon.awssdk.services.databasemigration.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `replication-instance`
      extends zio.aws.databasemigration.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.SourceType =
      software.amazon.awssdk.services.databasemigration.model.SourceType.REPLICATION_INSTANCE
  }
}
