package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationTaskIndividualAssessment(
    replicationTaskIndividualAssessmentArn: Optional[String] = Optional.Absent,
    replicationTaskAssessmentRunArn: Optional[String] = Optional.Absent,
    individualAssessmentName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    replicationTaskIndividualAssessmentStartDate: Optional[TStamp] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment = {
    import ReplicationTaskIndividualAssessment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment
      .builder()
      .optionallyWith(
        replicationTaskIndividualAssessmentArn.map(value =>
          value: java.lang.String
        )
      )(_.replicationTaskIndividualAssessmentArn)
      .optionallyWith(
        replicationTaskAssessmentRunArn.map(value => value: java.lang.String)
      )(_.replicationTaskAssessmentRunArn)
      .optionallyWith(
        individualAssessmentName.map(value => value: java.lang.String)
      )(_.individualAssessmentName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        replicationTaskIndividualAssessmentStartDate.map(value =>
          TStamp.unwrap(value): Instant
        )
      )(_.replicationTaskIndividualAssessmentStartDate)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly =
    zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment
      .wrap(buildAwsValue())
}
object ReplicationTaskIndividualAssessment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment =
      zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment(
        replicationTaskIndividualAssessmentArn.map(value => value),
        replicationTaskAssessmentRunArn.map(value => value),
        individualAssessmentName.map(value => value),
        status.map(value => value),
        replicationTaskIndividualAssessmentStartDate.map(value => value)
      )
    def replicationTaskIndividualAssessmentArn: Optional[String]
    def replicationTaskAssessmentRunArn: Optional[String]
    def individualAssessmentName: Optional[String]
    def status: Optional[String]
    def replicationTaskIndividualAssessmentStartDate: Optional[TStamp]
    def getReplicationTaskIndividualAssessmentArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationTaskIndividualAssessmentArn",
        replicationTaskIndividualAssessmentArn
      )
    def getReplicationTaskAssessmentRunArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationTaskAssessmentRunArn",
        replicationTaskAssessmentRunArn
      )
    def getIndividualAssessmentName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("individualAssessmentName", individualAssessmentName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReplicationTaskIndividualAssessmentStartDate
        : ZIO[Any, AwsError, TStamp] = AwsError.unwrapOptionField(
      "replicationTaskIndividualAssessmentStartDate",
      replicationTaskIndividualAssessmentStartDate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment
  ) extends zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly {
    override val replicationTaskIndividualAssessmentArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskIndividualAssessmentArn())
        .map(value => value: String)
    override val replicationTaskAssessmentRunArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationTaskAssessmentRunArn())
        .map(value => value: String)
    override val individualAssessmentName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.individualAssessmentName())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val replicationTaskIndividualAssessmentStartDate
        : Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskIndividualAssessmentStartDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment
  ): zio.aws.databasemigration.model.ReplicationTaskIndividualAssessment.ReadOnly =
    new Wrapper(impl)
}
