package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{TStamp, Integer}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ReplicationInstance(
    replicationInstanceIdentifier: Optional[String] = Optional.Absent,
    replicationInstanceClass: Optional[String] = Optional.Absent,
    replicationInstanceStatus: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.databasemigration.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    replicationSubnetGroup: Optional[
      zio.aws.databasemigration.model.ReplicationSubnetGroup
    ] = Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues
    ] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    replicationInstanceArn: Optional[String] = Optional.Absent,
    replicationInstancePublicIpAddress: Optional[String] = Optional.Absent,
    replicationInstancePrivateIpAddress: Optional[String] = Optional.Absent,
    replicationInstancePublicIpAddresses: Optional[Iterable[String]] =
      Optional.Absent,
    replicationInstancePrivateIpAddresses: Optional[Iterable[String]] =
      Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    secondaryAvailabilityZone: Optional[String] = Optional.Absent,
    freeUntil: Optional[TStamp] = Optional.Absent,
    dnsNameServers: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ReplicationInstance = {
    import ReplicationInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
      .builder()
      .optionallyWith(
        replicationInstanceIdentifier.map(value => value: java.lang.String)
      )(_.replicationInstanceIdentifier)
      .optionallyWith(
        replicationInstanceClass.map(value => value: java.lang.String)
      )(_.replicationInstanceClass)
      .optionallyWith(
        replicationInstanceStatus.map(value => value: java.lang.String)
      )(_.replicationInstanceStatus)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        replicationSubnetGroup.map(value => value.buildAwsValue())
      )(_.replicationSubnetGroup)
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(
        replicationInstancePublicIpAddress.map(value => value: java.lang.String)
      )(_.replicationInstancePublicIpAddress)
      .optionallyWith(
        replicationInstancePrivateIpAddress.map(value =>
          value: java.lang.String
        )
      )(_.replicationInstancePrivateIpAddress)
      .optionallyWith(
        replicationInstancePublicIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationInstancePublicIpAddresses)
      .optionallyWith(
        replicationInstancePrivateIpAddresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.replicationInstancePrivateIpAddresses)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(freeUntil.map(value => TStamp.unwrap(value): Instant))(
        _.freeUntil
      )
      .optionallyWith(dnsNameServers.map(value => value: java.lang.String))(
        _.dnsNameServers
      )
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.ReplicationInstance.ReadOnly =
    zio.aws.databasemigration.model.ReplicationInstance.wrap(buildAwsValue())
}
object ReplicationInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ReplicationInstance =
      zio.aws.databasemigration.model.ReplicationInstance(
        replicationInstanceIdentifier.map(value => value),
        replicationInstanceClass.map(value => value),
        replicationInstanceStatus.map(value => value),
        allocatedStorage.map(value => value),
        instanceCreateTime.map(value => value),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        replicationSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        kmsKeyId.map(value => value),
        replicationInstanceArn.map(value => value),
        replicationInstancePublicIpAddress.map(value => value),
        replicationInstancePrivateIpAddress.map(value => value),
        replicationInstancePublicIpAddresses.map(value => value),
        replicationInstancePrivateIpAddresses.map(value => value),
        publiclyAccessible.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        freeUntil.map(value => value),
        dnsNameServers.map(value => value)
      )
    def replicationInstanceIdentifier: Optional[String]
    def replicationInstanceClass: Optional[String]
    def replicationInstanceStatus: Optional[String]
    def allocatedStorage: Optional[Integer]
    def instanceCreateTime: Optional[TStamp]
    def vpcSecurityGroups: Optional[
      List[zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def availabilityZone: Optional[String]
    def replicationSubnetGroup: Optional[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues: Optional[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ]
    def multiAZ: Optional[Boolean]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def replicationInstanceArn: Optional[String]
    def replicationInstancePublicIpAddress: Optional[String]
    def replicationInstancePrivateIpAddress: Optional[String]
    def replicationInstancePublicIpAddresses: Optional[List[String]]
    def replicationInstancePrivateIpAddresses: Optional[List[String]]
    def publiclyAccessible: Optional[Boolean]
    def secondaryAvailabilityZone: Optional[String]
    def freeUntil: Optional[TStamp]
    def dnsNameServers: Optional[String]
    def getReplicationInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstanceIdentifier",
        replicationInstanceIdentifier
      )
    def getReplicationInstanceClass: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceClass", replicationInstanceClass)
    def getReplicationInstanceStatus: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceStatus", replicationInstanceStatus)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getReplicationSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationSubnetGroup",
      replicationSubnetGroup
    )
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getReplicationInstancePublicIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstancePublicIpAddress",
        replicationInstancePublicIpAddress
      )
    def getReplicationInstancePrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "replicationInstancePrivateIpAddress",
        replicationInstancePrivateIpAddress
      )
    def getReplicationInstancePublicIpAddresses
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "replicationInstancePublicIpAddresses",
      replicationInstancePublicIpAddresses
    )
    def getReplicationInstancePrivateIpAddresses
        : ZIO[Any, AwsError, List[String]] = AwsError.unwrapOptionField(
      "replicationInstancePrivateIpAddresses",
      replicationInstancePrivateIpAddresses
    )
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getFreeUntil: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("freeUntil", freeUntil)
    def getDnsNameServers: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsNameServers", dnsNameServers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ) extends zio.aws.databasemigration.model.ReplicationInstance.ReadOnly {
    override val replicationInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceIdentifier())
        .map(value => value: String)
    override val replicationInstanceClass: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceClass())
        .map(value => value: String)
    override val replicationInstanceStatus: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceStatus())
        .map(value => value: String)
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val vpcSecurityGroups: Optional[
      List[zio.aws.databasemigration.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val replicationSubnetGroup: Optional[
      zio.aws.databasemigration.model.ReplicationSubnetGroup.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationSubnetGroup())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationSubnetGroup.wrap(value)
      )
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues: Optional[
      zio.aws.databasemigration.model.ReplicationPendingModifiedValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingModifiedValues())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationPendingModifiedValues
          .wrap(value)
      )
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val replicationInstancePublicIpAddress: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstancePublicIpAddress())
        .map(value => value: String)
    override val replicationInstancePrivateIpAddress: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstancePrivateIpAddress())
        .map(value => value: String)
    override val replicationInstancePublicIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstancePublicIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val replicationInstancePrivateIpAddresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstancePrivateIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val secondaryAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAvailabilityZone())
        .map(value => value: String)
    override val freeUntil: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.freeUntil())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val dnsNameServers: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsNameServers())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ReplicationInstance
  ): zio.aws.databasemigration.model.ReplicationInstance.ReadOnly = new Wrapper(
    impl
  )
}
