package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait ReplicationEndpointTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue
}
object ReplicationEndpointTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue
  ): zio.aws.databasemigration.model.ReplicationEndpointTypeValue =
    value match {
      case software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.SOURCE =>
        val r = source
        r
      case software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.TARGET =>
        val r = target
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.ReplicationEndpointTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue =
      software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object source
      extends zio.aws.databasemigration.model.ReplicationEndpointTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue =
      software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.SOURCE
  }
  case object target
      extends zio.aws.databasemigration.model.ReplicationEndpointTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue =
      software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue.TARGET
  }
}
