package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait RefreshSchemasStatusTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue
}
object RefreshSchemasStatusTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue
  ): zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue =
    value match {
      case software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.SUCCESSFUL =>
        val r = successful
        r
      case software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.FAILED =>
        val r = failed
        r
      case software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.REFRESHING =>
        val r = refreshing
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object successful
      extends zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.SUCCESSFUL
  }
  case object failed
      extends zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.FAILED
  }
  case object refreshing
      extends zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatusTypeValue.REFRESHING
  }
}
