package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.TStamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RefreshSchemasStatus(
    endpointArn: Optional[String] = Optional.Absent,
    replicationInstanceArn: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = Optional.Absent,
    lastRefreshDate: Optional[TStamp] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus = {
    import RefreshSchemasStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
      .builder()
      .optionallyWith(endpointArn.map(value => value: java.lang.String))(
        _.endpointArn
      )
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastRefreshDate.map(value => TStamp.unwrap(value): Instant)
      )(_.lastRefreshDate)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly =
    zio.aws.databasemigration.model.RefreshSchemasStatus.wrap(buildAwsValue())
}
object RefreshSchemasStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RefreshSchemasStatus =
      zio.aws.databasemigration.model.RefreshSchemasStatus(
        endpointArn.map(value => value),
        replicationInstanceArn.map(value => value),
        status.map(value => value),
        lastRefreshDate.map(value => value),
        lastFailureMessage.map(value => value)
      )
    def endpointArn: Optional[String]
    def replicationInstanceArn: Optional[String]
    def status: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ]
    def lastRefreshDate: Optional[TStamp]
    def lastFailureMessage: Optional[String]
    def getEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointArn", endpointArn)
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = AwsError.unwrapOptionField("status", status)
    def getLastRefreshDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastRefreshDate", lastRefreshDate)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ) extends zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly {
    override val endpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointArn())
      .map(value => value: String)
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val status: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.databasemigration.model.RefreshSchemasStatusTypeValue
          .wrap(value)
      )
    override val lastRefreshDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastRefreshDate())
      .map(value => zio.aws.databasemigration.model.primitives.TStamp(value))
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RefreshSchemasStatus
  ): zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly =
    new Wrapper(impl)
}
