package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RedshiftSettings(
    acceptAnyDate: Optional[BooleanOptional] = Optional.Absent,
    afterConnectScript: Optional[String] = Optional.Absent,
    bucketFolder: Optional[String] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    caseSensitiveNames: Optional[BooleanOptional] = Optional.Absent,
    compUpdate: Optional[BooleanOptional] = Optional.Absent,
    connectionTimeout: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    dateFormat: Optional[String] = Optional.Absent,
    emptyAsNull: Optional[BooleanOptional] = Optional.Absent,
    encryptionMode: Optional[
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = Optional.Absent,
    explicitIds: Optional[BooleanOptional] = Optional.Absent,
    fileTransferUploadStreams: Optional[IntegerOptional] = Optional.Absent,
    loadTimeout: Optional[IntegerOptional] = Optional.Absent,
    maxFileSize: Optional[IntegerOptional] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    removeQuotes: Optional[BooleanOptional] = Optional.Absent,
    replaceInvalidChars: Optional[String] = Optional.Absent,
    replaceChars: Optional[String] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    serviceAccessRoleArn: Optional[String] = Optional.Absent,
    serverSideEncryptionKmsKeyId: Optional[String] = Optional.Absent,
    timeFormat: Optional[String] = Optional.Absent,
    trimBlanks: Optional[BooleanOptional] = Optional.Absent,
    truncateColumns: Optional[BooleanOptional] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    writeBufferSize: Optional[IntegerOptional] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.RedshiftSettings = {
    import RedshiftSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
      .builder()
      .optionallyWith(acceptAnyDate.map(value => value: java.lang.Boolean))(
        _.acceptAnyDate
      )
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(bucketFolder.map(value => value: java.lang.String))(
        _.bucketFolder
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        caseSensitiveNames.map(value => value: java.lang.Boolean)
      )(_.caseSensitiveNames)
      .optionallyWith(compUpdate.map(value => value: java.lang.Boolean))(
        _.compUpdate
      )
      .optionallyWith(connectionTimeout.map(value => value: Integer))(
        _.connectionTimeout
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(dateFormat.map(value => value: java.lang.String))(
        _.dateFormat
      )
      .optionallyWith(emptyAsNull.map(value => value: java.lang.Boolean))(
        _.emptyAsNull
      )
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .optionallyWith(explicitIds.map(value => value: java.lang.Boolean))(
        _.explicitIds
      )
      .optionallyWith(fileTransferUploadStreams.map(value => value: Integer))(
        _.fileTransferUploadStreams
      )
      .optionallyWith(loadTimeout.map(value => value: Integer))(_.loadTimeout)
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(removeQuotes.map(value => value: java.lang.Boolean))(
        _.removeQuotes
      )
      .optionallyWith(
        replaceInvalidChars.map(value => value: java.lang.String)
      )(_.replaceInvalidChars)
      .optionallyWith(replaceChars.map(value => value: java.lang.String))(
        _.replaceChars
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(
        serviceAccessRoleArn.map(value => value: java.lang.String)
      )(_.serviceAccessRoleArn)
      .optionallyWith(
        serverSideEncryptionKmsKeyId.map(value => value: java.lang.String)
      )(_.serverSideEncryptionKmsKeyId)
      .optionallyWith(timeFormat.map(value => value: java.lang.String))(
        _.timeFormat
      )
      .optionallyWith(trimBlanks.map(value => value: java.lang.Boolean))(
        _.trimBlanks
      )
      .optionallyWith(truncateColumns.map(value => value: java.lang.Boolean))(
        _.truncateColumns
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(writeBufferSize.map(value => value: Integer))(
        _.writeBufferSize
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.RedshiftSettings.ReadOnly =
    zio.aws.databasemigration.model.RedshiftSettings.wrap(buildAwsValue())
}
object RedshiftSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.RedshiftSettings =
      zio.aws.databasemigration.model.RedshiftSettings(
        acceptAnyDate.map(value => value),
        afterConnectScript.map(value => value),
        bucketFolder.map(value => value),
        bucketName.map(value => value),
        caseSensitiveNames.map(value => value),
        compUpdate.map(value => value),
        connectionTimeout.map(value => value),
        databaseName.map(value => value),
        dateFormat.map(value => value),
        emptyAsNull.map(value => value),
        encryptionMode.map(value => value),
        explicitIds.map(value => value),
        fileTransferUploadStreams.map(value => value),
        loadTimeout.map(value => value),
        maxFileSize.map(value => value),
        password.map(value => value),
        port.map(value => value),
        removeQuotes.map(value => value),
        replaceInvalidChars.map(value => value),
        replaceChars.map(value => value),
        serverName.map(value => value),
        serviceAccessRoleArn.map(value => value),
        serverSideEncryptionKmsKeyId.map(value => value),
        timeFormat.map(value => value),
        trimBlanks.map(value => value),
        truncateColumns.map(value => value),
        username.map(value => value),
        writeBufferSize.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def acceptAnyDate: Optional[BooleanOptional]
    def afterConnectScript: Optional[String]
    def bucketFolder: Optional[String]
    def bucketName: Optional[String]
    def caseSensitiveNames: Optional[BooleanOptional]
    def compUpdate: Optional[BooleanOptional]
    def connectionTimeout: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def dateFormat: Optional[String]
    def emptyAsNull: Optional[BooleanOptional]
    def encryptionMode
        : Optional[zio.aws.databasemigration.model.EncryptionModeValue]
    def explicitIds: Optional[BooleanOptional]
    def fileTransferUploadStreams: Optional[IntegerOptional]
    def loadTimeout: Optional[IntegerOptional]
    def maxFileSize: Optional[IntegerOptional]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def removeQuotes: Optional[BooleanOptional]
    def replaceInvalidChars: Optional[String]
    def replaceChars: Optional[String]
    def serverName: Optional[String]
    def serviceAccessRoleArn: Optional[String]
    def serverSideEncryptionKmsKeyId: Optional[String]
    def timeFormat: Optional[String]
    def trimBlanks: Optional[BooleanOptional]
    def truncateColumns: Optional[BooleanOptional]
    def username: Optional[String]
    def writeBufferSize: Optional[IntegerOptional]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def getAcceptAnyDate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("acceptAnyDate", acceptAnyDate)
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getBucketFolder: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketFolder", bucketFolder)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getCaseSensitiveNames: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("caseSensitiveNames", caseSensitiveNames)
    def getCompUpdate: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("compUpdate", compUpdate)
    def getConnectionTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("connectionTimeout", connectionTimeout)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getDateFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dateFormat", dateFormat)
    def getEmptyAsNull: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("emptyAsNull", emptyAsNull)
    def getEncryptionMode: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.EncryptionModeValue
    ] = AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getExplicitIds: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("explicitIds", explicitIds)
    def getFileTransferUploadStreams: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "fileTransferUploadStreams",
        fileTransferUploadStreams
      )
    def getLoadTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("loadTimeout", loadTimeout)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getRemoveQuotes: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("removeQuotes", removeQuotes)
    def getReplaceInvalidChars: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replaceInvalidChars", replaceInvalidChars)
    def getReplaceChars: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("replaceChars", replaceChars)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServiceAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceAccessRoleArn", serviceAccessRoleArn)
    def getServerSideEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "serverSideEncryptionKmsKeyId",
        serverSideEncryptionKmsKeyId
      )
    def getTimeFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timeFormat", timeFormat)
    def getTrimBlanks: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("trimBlanks", trimBlanks)
    def getTruncateColumns: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("truncateColumns", truncateColumns)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getWriteBufferSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("writeBufferSize", writeBufferSize)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ) extends zio.aws.databasemigration.model.RedshiftSettings.ReadOnly {
    override val acceptAnyDate: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptAnyDate())
        .map(value => value: BooleanOptional)
    override val afterConnectScript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.afterConnectScript())
      .map(value => value: String)
    override val bucketFolder: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketFolder())
      .map(value => value: String)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val caseSensitiveNames: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caseSensitiveNames())
        .map(value => value: BooleanOptional)
    override val compUpdate: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.compUpdate())
      .map(value => value: BooleanOptional)
    override val connectionTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionTimeout())
        .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val dateFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dateFormat())
      .map(value => value: String)
    override val emptyAsNull: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.emptyAsNull())
      .map(value => value: BooleanOptional)
    override val encryptionMode
        : Optional[zio.aws.databasemigration.model.EncryptionModeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value =>
          zio.aws.databasemigration.model.EncryptionModeValue.wrap(value)
        )
    override val explicitIds: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.explicitIds())
      .map(value => value: BooleanOptional)
    override val fileTransferUploadStreams: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileTransferUploadStreams())
        .map(value => value: IntegerOptional)
    override val loadTimeout: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.loadTimeout())
      .map(value => value: IntegerOptional)
    override val maxFileSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileSize())
      .map(value => value: IntegerOptional)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val removeQuotes: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.removeQuotes())
      .map(value => value: BooleanOptional)
    override val replaceInvalidChars: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replaceInvalidChars())
      .map(value => value: String)
    override val replaceChars: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.replaceChars())
      .map(value => value: String)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val serviceAccessRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceAccessRoleArn())
      .map(value => value: String)
    override val serverSideEncryptionKmsKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverSideEncryptionKmsKeyId())
        .map(value => value: String)
    override val timeFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timeFormat())
      .map(value => value: String)
    override val trimBlanks: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.trimBlanks())
      .map(value => value: BooleanOptional)
    override val truncateColumns: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truncateColumns())
        .map(value => value: BooleanOptional)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val writeBufferSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeBufferSize())
        .map(value => value: IntegerOptional)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.RedshiftSettings
  ): zio.aws.databasemigration.model.RedshiftSettings.ReadOnly = new Wrapper(
    impl
  )
}
