package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait RedisAuthTypeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue
}
object RedisAuthTypeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue
  ): zio.aws.databasemigration.model.RedisAuthTypeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.AUTH_ROLE =>
      val r = `auth-role`
      r
    case software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.AUTH_TOKEN =>
      val r = `auth-token`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.RedisAuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.databasemigration.model.RedisAuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.NONE
  }
  case object `auth-role`
      extends zio.aws.databasemigration.model.RedisAuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.AUTH_ROLE
  }
  case object `auth-token`
      extends zio.aws.databasemigration.model.RedisAuthTypeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue =
      software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue.AUTH_TOKEN
  }
}
