package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait PluginNameValue {
  def unwrap
      : software.amazon.awssdk.services.databasemigration.model.PluginNameValue
}
object PluginNameValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.PluginNameValue
  ): zio.aws.databasemigration.model.PluginNameValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.PluginNameValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.PluginNameValue.NO_PREFERENCE =>
      val r = `no-preference`
      r
    case software.amazon.awssdk.services.databasemigration.model.PluginNameValue.TEST_DECODING =>
      val r = `test-decoding`
      r
    case software.amazon.awssdk.services.databasemigration.model.PluginNameValue.PGLOGICAL =>
      val r = pglogical
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.PluginNameValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.PluginNameValue =
      software.amazon.awssdk.services.databasemigration.model.PluginNameValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `no-preference`
      extends zio.aws.databasemigration.model.PluginNameValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.PluginNameValue =
      software.amazon.awssdk.services.databasemigration.model.PluginNameValue.NO_PREFERENCE
  }
  case object `test-decoding`
      extends zio.aws.databasemigration.model.PluginNameValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.PluginNameValue =
      software.amazon.awssdk.services.databasemigration.model.PluginNameValue.TEST_DECODING
  }
  case object pglogical
      extends zio.aws.databasemigration.model.PluginNameValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.PluginNameValue =
      software.amazon.awssdk.services.databasemigration.model.PluginNameValue.PGLOGICAL
  }
}
