package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  SecretString,
  IntegerOptional,
  BooleanOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MySQLSettings(
    afterConnectScript: Optional[String] = Optional.Absent,
    cleanSourceMetadataOnMismatch: Optional[BooleanOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    eventsPollInterval: Optional[IntegerOptional] = Optional.Absent,
    targetDbType: Optional[zio.aws.databasemigration.model.TargetDbType] =
      Optional.Absent,
    maxFileSize: Optional[IntegerOptional] = Optional.Absent,
    parallelLoadThreads: Optional[IntegerOptional] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    serverTimezone: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MySQLSettings = {
    import MySQLSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MySQLSettings
      .builder()
      .optionallyWith(afterConnectScript.map(value => value: java.lang.String))(
        _.afterConnectScript
      )
      .optionallyWith(
        cleanSourceMetadataOnMismatch.map(value => value: java.lang.Boolean)
      )(_.cleanSourceMetadataOnMismatch)
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(eventsPollInterval.map(value => value: Integer))(
        _.eventsPollInterval
      )
      .optionallyWith(targetDbType.map(value => value.unwrap))(_.targetDbType)
      .optionallyWith(maxFileSize.map(value => value: Integer))(_.maxFileSize)
      .optionallyWith(parallelLoadThreads.map(value => value: Integer))(
        _.parallelLoadThreads
      )
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(serverTimezone.map(value => value: java.lang.String))(
        _.serverTimezone
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly: zio.aws.databasemigration.model.MySQLSettings.ReadOnly =
    zio.aws.databasemigration.model.MySQLSettings.wrap(buildAwsValue())
}
object MySQLSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MySQLSettings =
      zio.aws.databasemigration.model.MySQLSettings(
        afterConnectScript.map(value => value),
        cleanSourceMetadataOnMismatch.map(value => value),
        databaseName.map(value => value),
        eventsPollInterval.map(value => value),
        targetDbType.map(value => value),
        maxFileSize.map(value => value),
        parallelLoadThreads.map(value => value),
        password.map(value => value),
        port.map(value => value),
        serverName.map(value => value),
        serverTimezone.map(value => value),
        username.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def afterConnectScript: Optional[String]
    def cleanSourceMetadataOnMismatch: Optional[BooleanOptional]
    def databaseName: Optional[String]
    def eventsPollInterval: Optional[IntegerOptional]
    def targetDbType: Optional[zio.aws.databasemigration.model.TargetDbType]
    def maxFileSize: Optional[IntegerOptional]
    def parallelLoadThreads: Optional[IntegerOptional]
    def password: Optional[SecretString]
    def port: Optional[IntegerOptional]
    def serverName: Optional[String]
    def serverTimezone: Optional[String]
    def username: Optional[String]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def getAfterConnectScript: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("afterConnectScript", afterConnectScript)
    def getCleanSourceMetadataOnMismatch: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "cleanSourceMetadataOnMismatch",
        cleanSourceMetadataOnMismatch
      )
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getEventsPollInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("eventsPollInterval", eventsPollInterval)
    def getTargetDbType
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.TargetDbType] =
      AwsError.unwrapOptionField("targetDbType", targetDbType)
    def getMaxFileSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxFileSize", maxFileSize)
    def getParallelLoadThreads: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("parallelLoadThreads", parallelLoadThreads)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getServerTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverTimezone", serverTimezone)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ) extends zio.aws.databasemigration.model.MySQLSettings.ReadOnly {
    override val afterConnectScript: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.afterConnectScript())
      .map(value => value: String)
    override val cleanSourceMetadataOnMismatch: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cleanSourceMetadataOnMismatch())
        .map(value => value: BooleanOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val eventsPollInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventsPollInterval())
        .map(value => value: IntegerOptional)
    override val targetDbType
        : Optional[zio.aws.databasemigration.model.TargetDbType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetDbType())
        .map(value => zio.aws.databasemigration.model.TargetDbType.wrap(value))
    override val maxFileSize: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxFileSize())
      .map(value => value: IntegerOptional)
    override val parallelLoadThreads: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelLoadThreads())
        .map(value => value: IntegerOptional)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val serverTimezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverTimezone())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MySQLSettings
  ): zio.aws.databasemigration.model.MySQLSettings.ReadOnly = new Wrapper(impl)
}
