package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.{
  BooleanOptional,
  SecretString,
  IntegerOptional
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MicrosoftSQLServerSettings(
    port: Optional[IntegerOptional] = Optional.Absent,
    bcpPacketSize: Optional[IntegerOptional] = Optional.Absent,
    databaseName: Optional[String] = Optional.Absent,
    controlTablesFileGroup: Optional[String] = Optional.Absent,
    password: Optional[SecretString] = Optional.Absent,
    querySingleAlwaysOnNode: Optional[BooleanOptional] = Optional.Absent,
    readBackupOnly: Optional[BooleanOptional] = Optional.Absent,
    safeguardPolicy: Optional[zio.aws.databasemigration.model.SafeguardPolicy] =
      Optional.Absent,
    serverName: Optional[String] = Optional.Absent,
    username: Optional[String] = Optional.Absent,
    useBcpFullLoad: Optional[BooleanOptional] = Optional.Absent,
    useThirdPartyBackupDevice: Optional[BooleanOptional] = Optional.Absent,
    secretsManagerAccessRoleArn: Optional[String] = Optional.Absent,
    secretsManagerSecretId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings = {
    import MicrosoftSQLServerSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
      .builder()
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(bcpPacketSize.map(value => value: Integer))(
        _.bcpPacketSize
      )
      .optionallyWith(databaseName.map(value => value: java.lang.String))(
        _.databaseName
      )
      .optionallyWith(
        controlTablesFileGroup.map(value => value: java.lang.String)
      )(_.controlTablesFileGroup)
      .optionallyWith(
        password.map(value => SecretString.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        querySingleAlwaysOnNode.map(value => value: java.lang.Boolean)
      )(_.querySingleAlwaysOnNode)
      .optionallyWith(readBackupOnly.map(value => value: java.lang.Boolean))(
        _.readBackupOnly
      )
      .optionallyWith(safeguardPolicy.map(value => value.unwrap))(
        _.safeguardPolicy
      )
      .optionallyWith(serverName.map(value => value: java.lang.String))(
        _.serverName
      )
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(useBcpFullLoad.map(value => value: java.lang.Boolean))(
        _.useBcpFullLoad
      )
      .optionallyWith(
        useThirdPartyBackupDevice.map(value => value: java.lang.Boolean)
      )(_.useThirdPartyBackupDevice)
      .optionallyWith(
        secretsManagerAccessRoleArn.map(value => value: java.lang.String)
      )(_.secretsManagerAccessRoleArn)
      .optionallyWith(
        secretsManagerSecretId.map(value => value: java.lang.String)
      )(_.secretsManagerSecretId)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly =
    zio.aws.databasemigration.model.MicrosoftSQLServerSettings
      .wrap(buildAwsValue())
}
object MicrosoftSQLServerSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.MicrosoftSQLServerSettings =
      zio.aws.databasemigration.model.MicrosoftSQLServerSettings(
        port.map(value => value),
        bcpPacketSize.map(value => value),
        databaseName.map(value => value),
        controlTablesFileGroup.map(value => value),
        password.map(value => value),
        querySingleAlwaysOnNode.map(value => value),
        readBackupOnly.map(value => value),
        safeguardPolicy.map(value => value),
        serverName.map(value => value),
        username.map(value => value),
        useBcpFullLoad.map(value => value),
        useThirdPartyBackupDevice.map(value => value),
        secretsManagerAccessRoleArn.map(value => value),
        secretsManagerSecretId.map(value => value)
      )
    def port: Optional[IntegerOptional]
    def bcpPacketSize: Optional[IntegerOptional]
    def databaseName: Optional[String]
    def controlTablesFileGroup: Optional[String]
    def password: Optional[SecretString]
    def querySingleAlwaysOnNode: Optional[BooleanOptional]
    def readBackupOnly: Optional[BooleanOptional]
    def safeguardPolicy
        : Optional[zio.aws.databasemigration.model.SafeguardPolicy]
    def serverName: Optional[String]
    def username: Optional[String]
    def useBcpFullLoad: Optional[BooleanOptional]
    def useThirdPartyBackupDevice: Optional[BooleanOptional]
    def secretsManagerAccessRoleArn: Optional[String]
    def secretsManagerSecretId: Optional[String]
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getBcpPacketSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("bcpPacketSize", bcpPacketSize)
    def getDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("databaseName", databaseName)
    def getControlTablesFileGroup: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("controlTablesFileGroup", controlTablesFileGroup)
    def getPassword: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("password", password)
    def getQuerySingleAlwaysOnNode: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "querySingleAlwaysOnNode",
        querySingleAlwaysOnNode
      )
    def getReadBackupOnly: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("readBackupOnly", readBackupOnly)
    def getSafeguardPolicy
        : ZIO[Any, AwsError, zio.aws.databasemigration.model.SafeguardPolicy] =
      AwsError.unwrapOptionField("safeguardPolicy", safeguardPolicy)
    def getServerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverName", serverName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getUseBcpFullLoad: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("useBcpFullLoad", useBcpFullLoad)
    def getUseThirdPartyBackupDevice: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useThirdPartyBackupDevice",
        useThirdPartyBackupDevice
      )
    def getSecretsManagerAccessRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "secretsManagerAccessRoleArn",
        secretsManagerAccessRoleArn
      )
    def getSecretsManagerSecretId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secretsManagerSecretId", secretsManagerSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ) extends zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly {
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val bcpPacketSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bcpPacketSize())
        .map(value => value: IntegerOptional)
    override val databaseName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseName())
      .map(value => value: String)
    override val controlTablesFileGroup: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlTablesFileGroup())
        .map(value => value: String)
    override val password: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val querySingleAlwaysOnNode: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.querySingleAlwaysOnNode())
        .map(value => value: BooleanOptional)
    override val readBackupOnly: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readBackupOnly())
        .map(value => value: BooleanOptional)
    override val safeguardPolicy
        : Optional[zio.aws.databasemigration.model.SafeguardPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.safeguardPolicy())
        .map(value =>
          zio.aws.databasemigration.model.SafeguardPolicy.wrap(value)
        )
    override val serverName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverName())
      .map(value => value: String)
    override val username: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: String)
    override val useBcpFullLoad: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useBcpFullLoad())
        .map(value => value: BooleanOptional)
    override val useThirdPartyBackupDevice: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useThirdPartyBackupDevice())
        .map(value => value: BooleanOptional)
    override val secretsManagerAccessRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerAccessRoleArn())
        .map(value => value: String)
    override val secretsManagerSecretId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerSecretId())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings
  ): zio.aws.databasemigration.model.MicrosoftSQLServerSettings.ReadOnly =
    new Wrapper(impl)
}
