package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databasemigration.model.primitives.{
  CertificateWallet,
  SecretString
}
import scala.jdk.CollectionConverters.*
final case class ImportCertificateRequest(
    certificateIdentifier: String,
    certificatePem: Optional[SecretString] = Optional.Absent,
    certificateWallet: Optional[CertificateWallet] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest = {
    import ImportCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest
      .builder()
      .certificateIdentifier(certificateIdentifier: java.lang.String)
      .optionallyWith(
        certificatePem.map(value =>
          SecretString.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        certificateWallet.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.certificateWallet)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ImportCertificateRequest.ReadOnly =
    zio.aws.databasemigration.model.ImportCertificateRequest
      .wrap(buildAwsValue())
}
object ImportCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.ImportCertificateRequest =
      zio.aws.databasemigration.model.ImportCertificateRequest(
        certificateIdentifier,
        certificatePem.map(value => value),
        certificateWallet.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateIdentifier: String
    def certificatePem: Optional[SecretString]
    def certificateWallet: Optional[CertificateWallet]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def getCertificateIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(certificateIdentifier)
    def getCertificatePem: ZIO[Any, AwsError, SecretString] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getCertificateWallet: ZIO[Any, AwsError, CertificateWallet] =
      AwsError.unwrapOptionField("certificateWallet", certificateWallet)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest
  ) extends zio.aws.databasemigration.model.ImportCertificateRequest.ReadOnly {
    override val certificateIdentifier: String =
      impl.certificateIdentifier(): String
    override val certificatePem: Optional[SecretString] = zio.aws.core.internal
      .optionalFromNullable(impl.certificatePem())
      .map(value =>
        zio.aws.databasemigration.model.primitives.SecretString(value)
      )
    override val certificateWallet: Optional[CertificateWallet] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateWallet())
        .map(value =>
          zio.aws.databasemigration.model.primitives
            .CertificateWallet(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest
  ): zio.aws.databasemigration.model.ImportCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
