package zio.aws.databasemigration.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionModeValue {
  def unwrap: software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue
}
object EncryptionModeValue {
  def wrap(
      value: software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue
  ): zio.aws.databasemigration.model.EncryptionModeValue = value match {
    case software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.SSE_S3 =>
      val r = `sse-s3`
      r
    case software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.SSE_KMS =>
      val r = `sse-kms`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databasemigration.model.EncryptionModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue =
      software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.UNKNOWN_TO_SDK_VERSION
  }
  case object `sse-s3`
      extends zio.aws.databasemigration.model.EncryptionModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue =
      software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.SSE_S3
  }
  case object `sse-kms`
      extends zio.aws.databasemigration.model.EncryptionModeValue {
    override def unwrap
        : software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue =
      software.amazon.awssdk.services.databasemigration.model.EncryptionModeValue.SSE_KMS
  }
}
