package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeRefreshSchemasStatusResponse(
    refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse = {
    import DescribeRefreshSchemasStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse
      .builder()
      .optionallyWith(refreshSchemasStatus.map(value => value.buildAwsValue()))(
        _.refreshSchemasStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse
      .wrap(buildAwsValue())
}
object DescribeRefreshSchemasStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse =
      zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse(
        refreshSchemasStatus.map(value => value.asEditable)
      )
    def refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ]
    def getRefreshSchemasStatus: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ] = AwsError.unwrapOptionField("refreshSchemasStatus", refreshSchemasStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse
  ) extends zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly {
    override val refreshSchemasStatus: Optional[
      zio.aws.databasemigration.model.RefreshSchemasStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.refreshSchemasStatus())
      .map(value =>
        zio.aws.databasemigration.model.RefreshSchemasStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse
  ): zio.aws.databasemigration.model.DescribeRefreshSchemasStatusResponse.ReadOnly =
    new Wrapper(impl)
}
