package zio.aws.databasemigration.model
import zio.aws.databasemigration.model.primitives.IntegerOptional
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribePendingMaintenanceActionsRequest(
    replicationInstanceArn: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.databasemigration.model.Filter]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest = {
    import DescribePendingMaintenanceActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
      .builder()
      .optionallyWith(
        replicationInstanceArn.map(value => value: java.lang.String)
      )(_.replicationInstanceArn)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest =
      zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest(
        replicationInstanceArn.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value)
      )
    def replicationInstanceArn: Optional[String]
    def filters: Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]]
    def marker: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def getReplicationInstanceArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("replicationInstanceArn", replicationInstanceArn)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ) extends zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly {
    override val replicationInstanceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationInstanceArn())
        .map(value => value: String)
    override val filters
        : Optional[List[zio.aws.databasemigration.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest
  ): zio.aws.databasemigration.model.DescribePendingMaintenanceActionsRequest.ReadOnly =
    new Wrapper(impl)
}
