package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEndpointTypesResponse(
    marker: Optional[String] = Optional.Absent,
    supportedEndpointTypes: Optional[
      Iterable[zio.aws.databasemigration.model.SupportedEndpointType]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse = {
    import DescribeEndpointTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        supportedEndpointTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedEndpointTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEndpointTypesResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEndpointTypesResponse =
      zio.aws.databasemigration.model.DescribeEndpointTypesResponse(
        marker.map(value => value),
        supportedEndpointTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def supportedEndpointTypes: Optional[
      List[zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly]
    ]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getSupportedEndpointTypes: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "supportedEndpointTypes",
      supportedEndpointTypes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse
  ) extends zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val supportedEndpointTypes: Optional[
      List[zio.aws.databasemigration.model.SupportedEndpointType.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.supportedEndpointTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.SupportedEndpointType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse
  ): zio.aws.databasemigration.model.DescribeEndpointTypesResponse.ReadOnly =
    new Wrapper(impl)
}
