package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteReplicationTaskAssessmentRunResponse(
    replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse = {
    import DeleteReplicationTaskAssessmentRunResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse
      .builder()
      .optionallyWith(
        replicationTaskAssessmentRun.map(value => value.buildAwsValue())
      )(_.replicationTaskAssessmentRun)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse
      .wrap(buildAwsValue())
}
object DeleteReplicationTaskAssessmentRunResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse =
      zio.aws.databasemigration.model
        .DeleteReplicationTaskAssessmentRunResponse(
          replicationTaskAssessmentRun.map(value => value.asEditable)
        )
    def replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ]
    def getReplicationTaskAssessmentRun: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ] = AwsError.unwrapOptionField(
      "replicationTaskAssessmentRun",
      replicationTaskAssessmentRun
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse
  ) extends zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly {
    override val replicationTaskAssessmentRun: Optional[
      zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.replicationTaskAssessmentRun())
      .map(value =>
        zio.aws.databasemigration.model.ReplicationTaskAssessmentRun.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse
  ): zio.aws.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse.ReadOnly =
    new Wrapper(impl)
}
