package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteReplicationInstanceRequest(
    replicationInstanceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest = {
    import DeleteReplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest
      .builder()
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteReplicationInstanceRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteReplicationInstanceRequest
      .wrap(buildAwsValue())
}
object DeleteReplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DeleteReplicationInstanceRequest =
      zio.aws.databasemigration.model
        .DeleteReplicationInstanceRequest(replicationInstanceArn)
    def replicationInstanceArn: String
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest
  ) extends zio.aws.databasemigration.model.DeleteReplicationInstanceRequest.ReadOnly {
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest
  ): zio.aws.databasemigration.model.DeleteReplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
