package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteConnectionRequest(
    endpointArn: String,
    replicationInstanceArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest = {
    import DeleteConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest
      .builder()
      .endpointArn(endpointArn: java.lang.String)
      .replicationInstanceArn(replicationInstanceArn: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteConnectionRequest.ReadOnly =
    zio.aws.databasemigration.model.DeleteConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteConnectionRequest =
      zio.aws.databasemigration.model
        .DeleteConnectionRequest(endpointArn, replicationInstanceArn)
    def endpointArn: String
    def replicationInstanceArn: String
    def getEndpointArn: ZIO[Any, Nothing, String] = ZIO.succeed(endpointArn)
    def getReplicationInstanceArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest
  ) extends zio.aws.databasemigration.model.DeleteConnectionRequest.ReadOnly {
    override val endpointArn: String = impl.endpointArn(): String
    override val replicationInstanceArn: String =
      impl.replicationInstanceArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest
  ): zio.aws.databasemigration.model.DeleteConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
