package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteCertificateResponse(
    certificate: Optional[zio.aws.databasemigration.model.Certificate] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse = {
    import DeleteCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly =
    zio.aws.databasemigration.model.DeleteCertificateResponse
      .wrap(buildAwsValue())
}
object DeleteCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.DeleteCertificateResponse =
      zio.aws.databasemigration.model
        .DeleteCertificateResponse(certificate.map(value => value.asEditable))
    def certificate
        : Optional[zio.aws.databasemigration.model.Certificate.ReadOnly]
    def getCertificate: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Certificate.ReadOnly
    ] = AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ) extends zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly {
    override val certificate
        : Optional[zio.aws.databasemigration.model.Certificate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.databasemigration.model.Certificate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse
  ): zio.aws.databasemigration.model.DeleteCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
