package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateReplicationSubnetGroupRequest(
    replicationSubnetGroupIdentifier: String,
    replicationSubnetGroupDescription: String,
    subnetIds: Iterable[String],
    tags: Optional[Iterable[zio.aws.databasemigration.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest = {
    import CreateReplicationSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest
      .builder()
      .replicationSubnetGroupIdentifier(
        replicationSubnetGroupIdentifier: java.lang.String
      )
      .replicationSubnetGroupDescription(
        replicationSubnetGroupDescription: java.lang.String
      )
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest.ReadOnly =
    zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest
      .wrap(buildAwsValue())
}
object CreateReplicationSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest =
      zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest(
        replicationSubnetGroupIdentifier,
        replicationSubnetGroupDescription,
        subnetIds,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def replicationSubnetGroupIdentifier: String
    def replicationSubnetGroupDescription: String
    def subnetIds: List[String]
    def tags: Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]]
    def getReplicationSubnetGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationSubnetGroupIdentifier)
    def getReplicationSubnetGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(replicationSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest
  ) extends zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest.ReadOnly {
    override val replicationSubnetGroupIdentifier: String =
      impl.replicationSubnetGroupIdentifier(): String
    override val replicationSubnetGroupDescription: String =
      impl.replicationSubnetGroupDescription(): String
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val tags
        : Optional[List[zio.aws.databasemigration.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databasemigration.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest
  ): zio.aws.databasemigration.model.CreateReplicationSubnetGroupRequest.ReadOnly =
    new Wrapper(impl)
}
