package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(
    endpoint: Optional[zio.aws.databasemigration.model.Endpoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse
      .builder()
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly =
    zio.aws.databasemigration.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databasemigration.model.CreateEndpointResponse =
      zio.aws.databasemigration.model
        .CreateEndpointResponse(endpoint.map(value => value.asEditable))
    def endpoint: Optional[zio.aws.databasemigration.model.Endpoint.ReadOnly]
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.Endpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse
  ) extends zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly {
    override val endpoint
        : Optional[zio.aws.databasemigration.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.databasemigration.model.Endpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse
  ): zio.aws.databasemigration.model.CreateEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
