package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyMigrationProjectRequest(
    migrationProjectIdentifier: String,
    migrationProjectName: Optional[String] = Optional.Absent,
    sourceDataProviderDescriptors: Optional[
      Iterable[zio.aws.databasemigration.model.DataProviderDescriptorDefinition]
    ] = Optional.Absent,
    targetDataProviderDescriptors: Optional[
      Iterable[zio.aws.databasemigration.model.DataProviderDescriptorDefinition]
    ] = Optional.Absent,
    instanceProfileIdentifier: Optional[String] = Optional.Absent,
    transformationRules: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest = {
    import ModifyMigrationProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest
      .builder()
      .migrationProjectIdentifier(migrationProjectIdentifier: java.lang.String)
      .optionallyWith(
        migrationProjectName.map(value => value: java.lang.String)
      )(_.migrationProjectName)
      .optionallyWith(
        sourceDataProviderDescriptors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDataProviderDescriptors)
      .optionallyWith(
        targetDataProviderDescriptors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetDataProviderDescriptors)
      .optionallyWith(
        instanceProfileIdentifier.map(value => value: java.lang.String)
      )(_.instanceProfileIdentifier)
      .optionallyWith(
        transformationRules.map(value => value: java.lang.String)
      )(_.transformationRules)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        schemaConversionApplicationAttributes.map(value =>
          value.buildAwsValue()
        )
      )(_.schemaConversionApplicationAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.ModifyMigrationProjectRequest.ReadOnly =
    zio.aws.databasemigration.model.ModifyMigrationProjectRequest
      .wrap(buildAwsValue())
}
object ModifyMigrationProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.ModifyMigrationProjectRequest =
      zio.aws.databasemigration.model.ModifyMigrationProjectRequest(
        migrationProjectIdentifier,
        migrationProjectName.map(value => value),
        sourceDataProviderDescriptors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetDataProviderDescriptors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceProfileIdentifier.map(value => value),
        transformationRules.map(value => value),
        description.map(value => value),
        schemaConversionApplicationAttributes.map(value => value.asEditable)
      )
    def migrationProjectIdentifier: String
    def migrationProjectName: Optional[String]
    def sourceDataProviderDescriptors: Optional[List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]]
    def targetDataProviderDescriptors: Optional[List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]]
    def instanceProfileIdentifier: Optional[String]
    def transformationRules: Optional[String]
    def description: Optional[String]
    def schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ]
    def getMigrationProjectIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(migrationProjectIdentifier)
    def getMigrationProjectName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("migrationProjectName", migrationProjectName)
    def getSourceDataProviderDescriptors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "sourceDataProviderDescriptors",
      sourceDataProviderDescriptors
    )
    def getTargetDataProviderDescriptors: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "targetDataProviderDescriptors",
      targetDataProviderDescriptors
    )
    def getInstanceProfileIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("instanceProfileIdentifier", instanceProfileIdentifier)
    def getTransformationRules: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transformationRules", transformationRules)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSchemaConversionApplicationAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "schemaConversionApplicationAttributes",
      schemaConversionApplicationAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest
  ) extends zio.aws.databasemigration.model.ModifyMigrationProjectRequest.ReadOnly {
    override val migrationProjectIdentifier: String =
      impl.migrationProjectIdentifier(): String
    override val migrationProjectName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.migrationProjectName())
      .map(value => value: String)
    override val sourceDataProviderDescriptors: Optional[List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceDataProviderDescriptors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataProviderDescriptorDefinition
            .wrap(item)
        }.toList
      )
    override val targetDataProviderDescriptors: Optional[List[
      zio.aws.databasemigration.model.DataProviderDescriptorDefinition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetDataProviderDescriptors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.DataProviderDescriptorDefinition
            .wrap(item)
        }.toList
      )
    override val instanceProfileIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfileIdentifier())
        .map(value => value: String)
    override val transformationRules: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.transformationRules())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val schemaConversionApplicationAttributes: Optional[
      zio.aws.databasemigration.model.SCApplicationAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaConversionApplicationAttributes())
      .map(value =>
        zio.aws.databasemigration.model.SCApplicationAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest
  ): zio.aws.databasemigration.model.ModifyMigrationProjectRequest.ReadOnly =
    new Wrapper(impl)
}
