package zio.aws.databasemigration.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEngineVersionsResponse(
    engineVersions: Optional[
      Iterable[zio.aws.databasemigration.model.EngineVersion]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse = {
    import DescribeEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse
      .builder()
      .optionallyWith(
        engineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.engineVersions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly =
    zio.aws.databasemigration.model.DescribeEngineVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.databasemigration.model.DescribeEngineVersionsResponse =
      zio.aws.databasemigration.model.DescribeEngineVersionsResponse(
        engineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def engineVersions
        : Optional[List[zio.aws.databasemigration.model.EngineVersion.ReadOnly]]
    def marker: Optional[String]
    def getEngineVersions: ZIO[Any, AwsError, List[
      zio.aws.databasemigration.model.EngineVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("engineVersions", engineVersions)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse
  ) extends zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly {
    override val engineVersions: Optional[
      List[zio.aws.databasemigration.model.EngineVersion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.databasemigration.model.EngineVersion.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse
  ): zio.aws.databasemigration.model.DescribeEngineVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
